/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.UUID;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.BaseKey;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.DefaultProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.service.MintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;

public class CheckStateTask
implements Task<PostCheckStateResponse> {
    private final UUID mintId;
    private final PostCheckStateRequest request;
    private final MintProtocolService mintProtocolService;
    private final ProofVaultService proofVaultService;
    private final MintVaultService mintVaultService;

    public CheckStateTask(@NonNull UUID mintId, @NonNull PostCheckStateRequest request) {
        this(mintId, request, MintProtocolServiceFactory.getInstance(), new DefaultProofVaultService(), new DefaultMintVaultService());
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
    }

    public CheckStateTask(@NonNull UUID mintId, @NonNull PostCheckStateRequest request, @NonNull MintProtocolService mintProtocolService, @NonNull ProofVaultService proofVaultService, @NonNull MintVaultService mintVaultService) {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        this.mintId = mintId;
        this.request = request;
        this.mintProtocolService = mintProtocolService;
        this.proofVaultService = proofVaultService;
        this.mintVaultService = mintVaultService;
    }

    public PostCheckStateResponse execute() throws CashuErrorException {
        PostCheckStateResponse response = new PostCheckStateResponse();
        MintEntity mintEntity = this.mintProtocolService.toMintEntity(new Mint(this.mintId.toString()));
        this.mintVaultService.load(mintEntity, false, true);
        for (BaseKey hash : this.request.getHashToCurveSecrets()) {
            PostCheckStateResponse.ResponseState state = new PostCheckStateResponse.ResponseState();
            state.setHashToCurveSecret(hash);
            try {
                ProofEntity proofEntity = this.proofVaultService.retrieveProof(hash.toString());
                if ("PENDING".equals(proofEntity.getState())) {
                    state.setState("PENDING");
                } else {
                    state.setState("SPENT");
                }
                state.setWitness(proofEntity.getWitness());
            }
            catch (CashuErrorException e) {
                if (e.getMessage() != null && e.getMessage().toLowerCase().contains("not found")) {
                    state.setState("UNSPENT");
                }
                throw e;
            }
            response.addResponseState(state);
        }
        return response;
    }
}

