/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.tasks.SignBlindedMessageTask;
import xyz.tcheeric.cashu.mint.proto.util.ThreadUtil;
import xyz.tcheeric.gateway.common.Gateway;

public class MintTask<T extends Secret>
implements Task<PostMintResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintTask.class);
    private final PostMintRequest<T> postMintRequest;
    private final PaymentMethod method;
    private final Mint mint;
    private final MintProtocolService mintProtocolService;

    public MintTask(@NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService) {
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        this.postMintRequest = postMintRequest;
        this.method = method;
        this.mint = mint;
        this.mintProtocolService = mintProtocolService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostMintResponse execute() throws CashuErrorException {
        ThreadUtil.MINT_MELT_LOCK.lock();
        try {
            PostMintResponse result = new PostMintResponse();
            Gateway gateway = this.mintProtocolService.createGateway(this.method);
            if (!gateway.checkPaymentStatus(this.postMintRequest.getQuoteId())) {
                ErrorResponse error = new ErrorResponse("mint_invoice_not_paid_error");
                throw new CashuErrorException(error.toJson());
            }
            List blindedMessages = this.postMintRequest.getBlindedMessages();
            for (BlindedMessage bm : blindedMessages) {
                SignBlindedMessageTask signBlindedMessageTask = new SignBlindedMessageTask(this.mint, bm, this.mintProtocolService);
                BlindSignature bSignature = signBlindedMessageTask.execute();
                result.addBlindSignature(bSignature);
            }
            PostMintResponse postMintResponse = result;
            return postMintResponse;
        }
        finally {
            ThreadUtil.MINT_MELT_LOCK.unlock();
        }
    }
}

