/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.mint.proto.nut.NUT01;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;

public class LoadKeySetsTask
implements Task<List<KeySet>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadKeySetsTask.class);
    private final UUID mintId;
    private final MintLoadService mintLoadService;

    public LoadKeySetsTask(@NonNull UUID mintId) {
        this(mintId, new DefaultMintLoadService());
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
    }

    public LoadKeySetsTask(@NonNull UUID mintId, @NonNull MintLoadService mintLoadService) {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        this.mintId = mintId;
        this.mintLoadService = mintLoadService;
    }

    public List<KeySet> execute() throws CashuErrorException {
        log.debug("execute()");
        Mint mint = this.mintLoadService.load(this.mintId, false);
        Set keySets = mint.getKeySets();
        for (KeySet keySet : keySets) {
            if (keySet.getId() != null) continue;
            String unit = keySet.getUnit();
            try {
                keySet.setId(NUT01.generateKeySet(this.mintId, unit).getId());
            }
            catch (CashuErrorException e) {
                log.error("Failed to generate KeySet for mintId {} and unit {}: {}", new Object[]{this.mintId, unit, e.getMessage(), e});
                throw e;
            }
        }
        return new ArrayList<KeySet>(keySets);
    }
}

