/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import lombok.NonNull;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.util.FeeConfig;
import xyz.tcheeric.gateway.common.Gateway;

public class MeltQuoteTask
implements Task<PostMeltQuoteResponse> {
    private final PostMeltQuoteRequest request;
    private final PaymentMethod method;
    private final MintProtocolService mintProtocolService;

    public MeltQuoteTask(@NonNull PostMeltQuoteRequest request, @NonNull PaymentMethod method) {
        this(request, method, MintProtocolServiceFactory.getInstance());
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
    }

    public MeltQuoteTask(@NonNull PostMeltQuoteRequest request, @NonNull PaymentMethod method, @NonNull MintProtocolService mintProtocolService) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        this.request = request;
        this.method = method;
        this.mintProtocolService = mintProtocolService;
    }

    public PostMeltQuoteResponse execute() throws CashuErrorException {
        Gateway gateway = this.mintProtocolService.createGateway(this.method);
        String quoteId = gateway.createMeltQuote(this.request.getRequest());
        int feeReserve = gateway.getFeeReserve(quoteId);
        Integer expiry = gateway.getPaymentExpiry(quoteId);
        int amount = gateway.getAmount(quoteId);
        return PostMeltQuoteResponse.builder().quoteId(quoteId).feeReserve(feeReserve += (int)Math.ceil((double)amount * FeeConfig.getFeeReservePercent())).expiry(expiry.intValue()).amount(amount).build();
    }
}

