/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.tasks.MintTask;

public class MintTokensTask<T extends Secret>
implements Task<PostMintResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintTokensTask.class);
    private final UUID mintId;
    private final PostMintRequest<T> postMintRequest;
    private final PaymentMethod method;
    private final MintLoadService mintLoadService;
    private final MintProtocolService mintProtocolService;

    public MintTokensTask(@NonNull UUID mintId, @NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method) {
        this(mintId, postMintRequest, method, new DefaultMintLoadService(), MintProtocolServiceFactory.getInstance());
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
    }

    public MintTokensTask(@NonNull UUID mintId, @NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method, @NonNull MintLoadService mintLoadService, @NonNull MintProtocolService mintProtocolService) {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        this.mintId = mintId;
        this.postMintRequest = postMintRequest;
        this.method = method;
        this.mintLoadService = mintLoadService;
        this.mintProtocolService = mintProtocolService;
    }

    public PostMintResponse execute() throws CashuErrorException {
        Mint mint = this.mintLoadService.load(this.mintId, false);
        return new MintTask<T>(this.postMintRequest, this.method, mint, this.mintProtocolService).execute();
    }
}

