/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.ArrayList;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostRestoreRequest;
import xyz.tcheeric.cashu.entities.rest.PostRestoreResponse;
import xyz.tcheeric.cashu.mint.proto.service.DefaultSignatureVaultService;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;

public class RestoreSignaturesTask
implements Task<PostRestoreResponse> {
    private final PostRestoreRequest request;
    private final SignatureVaultService signatureVaultService;

    public RestoreSignaturesTask(@NonNull PostRestoreRequest request) {
        this(request, new DefaultSignatureVaultService());
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
    }

    public RestoreSignaturesTask(@NonNull PostRestoreRequest request, @NonNull SignatureVaultService signatureVaultService) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
        this.request = request;
        this.signatureVaultService = signatureVaultService;
    }

    public PostRestoreResponse execute() throws CashuErrorException {
        ArrayList<BlindedMessage> outputs = new ArrayList<BlindedMessage>();
        ArrayList<BlindSignature> signatures = new ArrayList<BlindSignature>();
        for (BlindedMessage bm : this.request.getBlindedMessages()) {
            BlindSignature sig = this.signatureVaultService.retrieve(bm);
            if (sig == null) continue;
            outputs.add(bm);
            signatures.add(sig);
        }
        return new PostRestoreResponse(outputs, signatures);
    }
}

