/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import lombok.NonNull;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.mint.proto.service.DefaultSignatureVaultService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;

public class SignBlindedMessageTask
implements Task<BlindSignature> {
    private final Mint mint;
    private final BlindedMessage blindedMessage;
    private final MintProtocolService mintProtocolService;
    private final SignatureVaultService signatureVaultService;

    public SignBlindedMessageTask(@NonNull Mint mint, @NonNull BlindedMessage blindedMessage, @NonNull MintProtocolService mintProtocolService) {
        this(mint, blindedMessage, mintProtocolService, new DefaultSignatureVaultService());
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (blindedMessage == null) {
            throw new NullPointerException("blindedMessage is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
    }

    public SignBlindedMessageTask(@NonNull Mint mint, @NonNull BlindedMessage blindedMessage, @NonNull MintProtocolService mintProtocolService, @NonNull SignatureVaultService signatureVaultService) {
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (blindedMessage == null) {
            throw new NullPointerException("blindedMessage is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
        this.mint = mint;
        this.blindedMessage = blindedMessage;
        this.mintProtocolService = mintProtocolService;
        this.signatureVaultService = signatureVaultService;
    }

    public BlindSignature execute() throws CashuErrorException {
        BlindSignature blindSignature;
        PrivateKey privateKey = this.getPrivateKey(this.blindedMessage, this.mint);
        if (privateKey == null) {
            ErrorResponse error = new ErrorResponse("sign_private_key_not_found");
            throw new CashuErrorException(error.toJson());
        }
        byte[] signature = BDHKEUtils.signBlindedMessage((byte[])this.blindedMessage.getBlindedMessage().toBytes(), (byte[])privateKey.toBytes());
        if (signature != null && signature.length == 64) {
            blindSignature = new BlindSignature(this.blindedMessage.getAmount(), this.blindedMessage.getKeySetId(), Signature.fromBytes((byte[])signature));
        } else {
            String hex = SignBlindedMessageTask.bytesToHex(signature);
            blindSignature = new BlindSignature(this.blindedMessage.getAmount(), this.blindedMessage.getKeySetId(), Signature.fromString((String)hex));
        }
        this.signatureVaultService.store(this.blindedMessage, blindSignature);
        return blindSignature;
    }

    private PrivateKey getPrivateKey(@NonNull BlindedMessage blindedMessage, @NonNull Mint mint) throws CashuErrorException {
        if (blindedMessage == null) {
            throw new NullPointerException("blindedMessage is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        return this.mintProtocolService.getPrivateKey(blindedMessage.getKeySetId().toString(), blindedMessage.getAmount(), mint);
    }

    private static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hexString = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }
}

