/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.nut;

import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.MintQuoteStatusTask;
import xyz.tcheeric.cashu.mint.proto.tasks.MintQuoteTask;
import xyz.tcheeric.cashu.mint.proto.tasks.MintTokensTask;

@Nut(value=4, description="Mint tokens")
public class NUT04 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NUT04.class);

    public static PostMintQuoteResponse quote(int amount, @NonNull PaymentMethod method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return new MintQuoteTask(amount, method).execute();
    }

    public static PostMintQuoteResponse quote(int amount, @NonNull PaymentMethod method, String unit) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return new MintQuoteTask(amount, method, unit, MintProtocolServiceFactory.getInstance()).execute();
    }

    public static PostMintQuoteResponse quotePaymentStatus(@NonNull String quoteId, @NonNull PaymentMethod method) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return new MintQuoteStatusTask(quoteId, method).execute();
    }

    public static PostMintQuoteResponse quotePaymentStatus(@NonNull String quoteId, @NonNull PaymentMethod method, String unit) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return new MintQuoteStatusTask(quoteId, method, unit, MintProtocolServiceFactory.getInstance()).execute();
    }

    public static <T extends Secret> PostMintResponse mint(@NonNull UUID mintId, @NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method, @NonNull SignatureVaultService signatureVaultService) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
        return NUT04.mint(mintId, postMintRequest, method, null, new DefaultMintLoadService(), MintProtocolServiceFactory.getInstance(), signatureVaultService);
    }

    public static <T extends Secret> PostMintResponse mint(@NonNull UUID mintId, @NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method, String unit, @NonNull MintLoadService mintLoadService, @NonNull MintProtocolService mintProtocolService, @NonNull SignatureVaultService signatureVaultService) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
        return new MintTokensTask<T>(mintId, postMintRequest, method, unit, mintLoadService, mintProtocolService, signatureVaultService).execute();
    }
}

