/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.service;

import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.mint.proto.service.MintInfoService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.util.MintInfo;
import xyz.tcheeric.cashu.mint.proto.util.MintProtocolUtil;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;
import xyz.tcheeric.gateway.common.Gateway;

@Service
public class DefaultMintProtocolService
implements MintProtocolService {
    private MintInfoService mintInfoService;

    @Autowired(required=false)
    public void setMintInfoService(MintInfoService mintInfoService) {
        this.mintInfoService = mintInfoService;
    }

    @Override
    public Gateway createGateway(@NonNull PaymentMethod method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        String unit = this.resolveUnitForMethod(method);
        return MintProtocolUtil.createGateway(method, unit);
    }

    @Override
    public Gateway createGateway(@NonNull PaymentMethod method, String unit) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return MintProtocolUtil.createGateway(method, unit);
    }

    @Override
    public PrivateKey getPrivateKey(@NonNull String keySetId, @NonNull Integer amount, @NonNull Mint mint) throws CashuErrorException {
        if (keySetId == null) {
            throw new NullPointerException("keySetId is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        return MintProtocolUtil.getPrivateKey(keySetId, amount, mint);
    }

    @Override
    public MintEntity toMintEntity(@NonNull Mint mint) {
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        return MintProtocolUtil.toMintEntity(mint);
    }

    @Override
    public <T extends Secret> ProofEntity toProofEntity(@NonNull Proof<T> proof, @NonNull MintEntity mintEntity) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (mintEntity == null) {
            throw new NullPointerException("mintEntity is marked non-null but is null");
        }
        return MintProtocolUtil.toProofEntity(proof, mintEntity);
    }

    private String resolveUnitForMethod(PaymentMethod method) {
        if (this.mintInfoService == null) {
            return null;
        }
        try {
            MintInfo info = this.mintInfoService.getMintInfo();
            if (info != null && info.getNuts() != null) {
                String methodKey = method.name().toLowerCase();
                for (MintInfo.Nut nut : info.getNuts().values()) {
                    if (nut.getMethods() == null) continue;
                    for (MintInfo.Nut.Method m : nut.getMethods()) {
                        if (m.getMethod() == null || !m.getMethod().equalsIgnoreCase(methodKey) || m.getUnit() == null || m.getUnit().isBlank()) continue;
                        return m.getUnit();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

