/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import lombok.NonNull;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolServiceFactory;
import xyz.tcheeric.gateway.common.Gateway;

public class MintQuoteTask
implements Task<PostMintQuoteResponse> {
    private final int amount;
    private final PaymentMethod method;
    private final String unit;
    private final MintProtocolService mintProtocolService;

    public MintQuoteTask(int amount, @NonNull PaymentMethod method) {
        this(amount, method, null, MintProtocolServiceFactory.getInstance());
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
    }

    public MintQuoteTask(int amount, @NonNull PaymentMethod method, String unit, @NonNull MintProtocolService mintProtocolService) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        this.amount = amount;
        this.method = method;
        this.unit = unit;
        this.mintProtocolService = mintProtocolService;
    }

    public MintQuoteTask(int amount, @NonNull PaymentMethod method, @NonNull MintProtocolService mintProtocolService) {
        this(amount, method, null, mintProtocolService);
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
    }

    public PostMintQuoteResponse execute() {
        Gateway gateway = this.unit == null ? this.mintProtocolService.createGateway(this.method) : this.mintProtocolService.createGateway(this.method, this.unit);
        String quoteId = gateway.createMintQuote(Integer.valueOf(this.amount), null);
        String request = gateway.getRequest(quoteId);
        Integer expiry = gateway.getPaymentExpiry(quoteId);
        return PostMintQuoteResponse.builder().quoteId(quoteId).request(request).expiry(expiry.intValue()).build();
    }
}

