/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.nut;

import java.util.UUID;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.CheckStateTask;

@Nut(value=7, description="Check the state of a proof")
public class NUT07 {
    public static final String UNSPENT = "UNSPENT";
    public static final String PENDING = "PENDING";
    public static final String SPENT = "SPENT";

    public static PostCheckStateResponse checkState(@NonNull UUID mintId, @NonNull PostCheckStateRequest postCheckStateRequest) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (postCheckStateRequest == null) {
            throw new NullPointerException("postCheckStateRequest is marked non-null but is null");
        }
        return new CheckStateTask(mintId, postCheckStateRequest).execute();
    }

    public static PostCheckStateResponse checkState(@NonNull UUID mintId, @NonNull PostCheckStateRequest postCheckStateRequest, @NonNull MintProtocolService mintProtocolService, @NonNull ProofVaultService proofVaultService, @NonNull MintVaultService mintVaultService) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (postCheckStateRequest == null) {
            throw new NullPointerException("postCheckStateRequest is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        return new CheckStateTask(mintId, postCheckStateRequest, mintProtocolService, proofVaultService, mintVaultService).execute();
    }
}

