/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.DefaultProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.InvalidateProofsTask;
import xyz.tcheeric.cashu.mint.proto.util.FeeConfig;
import xyz.tcheeric.cashu.mint.proto.util.ThreadUtil;
import xyz.tcheeric.gateway.common.Gateway;

public class MeltTask<T extends Secret>
implements Task<PostMeltResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeltTask.class);
    private final PostMeltRequest<T> postMeltRequest;
    private final PaymentMethod method;
    private final String unit;
    private final Mint mint;
    private final MintProtocolService mintProtocolService;
    private final MintLoadService mintLoadService;
    private final MintVaultService mintVaultService;
    private final ProofVaultService proofVaultService;

    public MeltTask(@NonNull PostMeltRequest<T> postMeltRequest, @NonNull PaymentMethod method, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService) {
        this(postMeltRequest, method, null, mint, mintProtocolService, new DefaultMintLoadService(), new DefaultMintVaultService(), new DefaultProofVaultService());
        if (postMeltRequest == null) {
            throw new NullPointerException("postMeltRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
    }

    public MeltTask(@NonNull PostMeltRequest<T> postMeltRequest, @NonNull PaymentMethod method, String unit, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService, @NonNull MintLoadService mintLoadService, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) {
        if (postMeltRequest == null) {
            throw new NullPointerException("postMeltRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
        this.postMeltRequest = postMeltRequest;
        this.method = method;
        this.unit = unit;
        this.mint = mint;
        this.mintLoadService = mintLoadService;
        this.mintProtocolService = mintProtocolService;
        this.mintVaultService = mintVaultService;
        this.proofVaultService = proofVaultService;
    }

    public MeltTask(@NonNull PostMeltRequest<T> postMeltRequest, @NonNull PaymentMethod method, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService, @NonNull MintLoadService mintLoadService, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) {
        this(postMeltRequest, method, null, mint, mintProtocolService, mintLoadService, mintVaultService, proofVaultService);
        if (postMeltRequest == null) {
            throw new NullPointerException("postMeltRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostMeltResponse execute() throws CashuErrorException {
        ThreadUtil.MINT_MELT_LOCK.lock();
        try {
            List proofsToMelt = this.postMeltRequest.getInputs();
            for (Proof proof2 : proofsToMelt) {
                if (this.verify(proof2)) continue;
                ErrorResponse error = new ErrorResponse("melt_proof_verification_error");
                throw new CashuErrorException(error.toJson());
            }
            String keySetId = ((Proof)proofsToMelt.get(0)).getKeySetId();
            KeySet keyset = this.mintLoadService.keySet(keySetId);
            String quoteId = this.postMeltRequest.getQuoteId();
            Gateway gateway = this.unit == null ? this.mintProtocolService.createGateway(this.method) : this.mintProtocolService.createGateway(this.method, this.unit);
            Integer amount = gateway.getAmount(quoteId);
            String request = gateway.getRequest(quoteId);
            Integer fee_reserve = gateway.getFeeReserve(quoteId);
            int calculated_fee_reserve = fee_reserve + (int)Math.ceil((double)amount.intValue() * FeeConfig.getFeeReservePercent());
            log.debug("Processing melt quote {} for request {} with fee reserve {}", new Object[]{quoteId, request, calculated_fee_reserve});
            int totalAmount = proofsToMelt.stream().mapToInt(proof -> proof.getAmount()).sum() + this.postMeltRequest.getFees(keyset) + calculated_fee_reserve;
            if (totalAmount < amount + fee_reserve) {
                ErrorResponse error = new ErrorResponse("melt_proof_amount_error");
                throw new CashuErrorException(error.toJson());
            }
            gateway.pay(quoteId);
            boolean paid = gateway.checkPaymentStatus(quoteId);
            if (!paid) {
                ErrorResponse error = new ErrorResponse("melt_invoice_not_paid_error");
                throw new CashuErrorException(error.toJson());
            }
            new InvalidateProofsTask(this.mint, proofsToMelt, this.mintVaultService, this.proofVaultService).execute();
            PostMeltResponse postMeltResponse = new PostMeltResponse(paid, gateway.getPaymentPreimage(quoteId));
            return postMeltResponse;
        }
        finally {
            ThreadUtil.MINT_MELT_LOCK.unlock();
        }
    }

    public boolean verify(@NonNull Proof proof) throws CashuErrorException {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        PrivateKey privateKey = this.mintProtocolService.getPrivateKey(proof.getKeySetId(), proof.getAmount(), this.mint);
        if (privateKey != null) {
            return BDHKEUtils.verify((String)proof.getSecret().toString(), (byte[])privateKey.toBytes(), (byte[])proof.getUnblindedSignature().getBytes());
        }
        return false;
    }
}

