/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import lombok.NonNull;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolServiceFactory;
import xyz.tcheeric.gateway.common.Gateway;

public class MintQuoteStatusTask
implements Task<PostMintQuoteResponse> {
    private final String quoteId;
    private final PaymentMethod method;
    private final String unit;
    private final MintProtocolService mintProtocolService;

    public MintQuoteStatusTask(@NonNull String quoteId, @NonNull PaymentMethod method) {
        this(quoteId, method, null, MintProtocolServiceFactory.getInstance());
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
    }

    public MintQuoteStatusTask(@NonNull String quoteId, @NonNull PaymentMethod method, String unit, @NonNull MintProtocolService mintProtocolService) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        this.quoteId = quoteId;
        this.method = method;
        this.unit = unit;
        this.mintProtocolService = mintProtocolService;
    }

    public MintQuoteStatusTask(@NonNull String quoteId, @NonNull PaymentMethod method, @NonNull MintProtocolService mintProtocolService) {
        this(quoteId, method, null, mintProtocolService);
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
    }

    public PostMintQuoteResponse execute() {
        Gateway gateway = this.unit == null ? this.mintProtocolService.createGateway(this.method) : this.mintProtocolService.createGateway(this.method, this.unit);
        return PostMintQuoteResponse.builder().quoteId(this.quoteId).request(gateway.getRequest(this.quoteId)).expiry(gateway.getPaymentExpiry(this.quoteId).intValue()).paid(gateway.checkPaymentStatus(this.quoteId)).build();
    }
}

