/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks.validator;

import lombok.Generated;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.mint.proto.service.DefaultProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.validator.SpendingCondition;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;

public class RSSSpendingCondition
implements SpendingCondition<RandomStringSecret> {
    private final Mint mint;
    private final MintProtocolService mintProtocolService;
    private final ProofVaultService proofVaultService;

    public RSSSpendingCondition(@NonNull Mint mint, @NonNull MintProtocolService mintProtocolService) {
        this(mint, mintProtocolService, new DefaultProofVaultService());
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
    }

    @Override
    public void verify(Proof<RandomStringSecret> proof) throws CashuErrorException {
        Secret secret = proof.getSecret();
        ProofEntity proofEntity = null;
        try {
            proofEntity = this.proofVaultService.retrieveProof(secret.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (proofEntity != null) {
            ErrorResponse error = new ErrorResponse("verify_proof_already_used_error");
            throw new CashuErrorException(error.toJson());
        }
        if (proof.getKeySetId() != null) {
            boolean found = false;
            for (KeySet ks : this.mint.getKeySets()) {
                if (!proof.getKeySetId().equals(ks.getId())) continue;
                found = true;
                break;
            }
            if (!found) {
                ErrorResponse error = new ErrorResponse("verify_proof_key_set_not_found");
                throw new CashuErrorException(error.toJson());
            }
        } else {
            ErrorResponse error = new ErrorResponse("verify_proof_key_set_id_error");
            throw new CashuErrorException(error.toJson());
        }
        PrivateKey privateKey = this.getPrivateKey(proof, this.mint);
        if (privateKey == null) {
            throw new IllegalStateException("Private key not found");
        }
        byte[] C = proof.getUnblindedSignature().getBytes();
        if (!BDHKEUtils.verify((String)secret.toString(), (byte[])privateKey.toBytes(), (byte[])C)) {
            ErrorResponse error = new ErrorResponse("verify_proof_failed_error");
            throw new CashuErrorException(error.toJson());
        }
    }

    private PrivateKey getPrivateKey(@NonNull Proof<RandomStringSecret> proof, @NonNull Mint mint) throws CashuErrorException {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        return this.mintProtocolService.getPrivateKey(proof.getKeySetId(), proof.getAmount(), mint);
    }

    @Generated
    public RSSSpendingCondition(Mint mint, MintProtocolService mintProtocolService, ProofVaultService proofVaultService) {
        this.mint = mint;
        this.mintProtocolService = mintProtocolService;
        this.proofVaultService = proofVaultService;
    }
}

