/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class FeeConfig {
    private static final Properties PROPERTIES = new Properties();
    private static final double DEFAULT_PERCENT = 0.05;

    private FeeConfig() {
    }

    public static double getFeeReservePercent() {
        String value = PROPERTIES.getProperty("cashu.melt.fee-reserve-percent", String.valueOf(0.05));
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return 0.05;
        }
    }

    static {
        try (InputStream input = FeeConfig.class.getClassLoader().getResourceAsStream("proto.properties");){
            if (input != null) {
                PROPERTIES.load(input);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

