/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.ActiveKeySet;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;

public class ActiveKeySetsTask
implements Task<List<ActiveKeySet>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActiveKeySetsTask.class);
    private final MintLoadService mintLoadService;

    public ActiveKeySetsTask() {
        this(new DefaultMintLoadService());
    }

    public ActiveKeySetsTask(@NonNull MintLoadService mintLoadService) {
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        this.mintLoadService = mintLoadService;
    }

    public List<ActiveKeySet> execute() throws CashuErrorException {
        log.debug("execute()");
        ArrayList<ActiveKeySet> result = new ArrayList<ActiveKeySet>();
        this.mintLoadService.keySets(false).stream().map(keySet -> ActiveKeySet.fromKeySet((KeySet)keySet, (boolean)true)).forEach(result::add);
        this.mintLoadService.keySets(true).stream().map(keySet -> ActiveKeySet.fromKeySet((KeySet)keySet, (boolean)false)).forEach(result::add);
        result.sort(Comparator.comparing(ActiveKeySet::getId));
        return result;
    }
}

