/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.UUID;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.MeltTask;

public class MeltTokensTask<T extends Secret>
implements Task<PostMeltResponse> {
    private final UUID mintId;
    private final PostMeltRequest<T> request;
    private final PaymentMethod method;
    private final MintProtocolService mintProtocolService;
    private final MintLoadService mintLoadService;
    private final MintVaultService mintVaultService;
    private final ProofVaultService proofVaultService;
    private final String unit;

    public MeltTokensTask(@NonNull UUID mintId, @NonNull PostMeltRequest<T> request, @NonNull PaymentMethod method, String unit, @NonNull MintProtocolService mintProtocolService, @NonNull MintLoadService mintLoadService, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
        this.mintId = mintId;
        this.request = request;
        this.method = method;
        this.mintProtocolService = mintProtocolService;
        this.mintLoadService = mintLoadService;
        this.mintVaultService = mintVaultService;
        this.proofVaultService = proofVaultService;
        this.unit = unit;
    }

    public MeltTokensTask(@NonNull UUID mintId, @NonNull PostMeltRequest<T> request, @NonNull PaymentMethod method, @NonNull MintProtocolService mintProtocolService, @NonNull MintLoadService mintLoadService, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) {
        this(mintId, request, method, null, mintProtocolService, mintLoadService, mintVaultService, proofVaultService);
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
    }

    public PostMeltResponse execute() throws CashuErrorException {
        Mint mint = this.mintLoadService.load(this.mintId, true);
        MeltTask<T> meltTask = new MeltTask<T>(this.request, this.method, this.unit, mint, this.mintProtocolService, this.mintLoadService, this.mintVaultService, this.proofVaultService);
        return meltTask.execute();
    }
}

