/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;

public class SignBlindedMessageTask
implements Task<BlindSignature> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignBlindedMessageTask.class);
    private final Mint mint;
    private final BlindedMessage blindedMessage;
    private final MintProtocolService mintProtocolService;
    private final SignatureVaultService signatureVaultService;

    public SignBlindedMessageTask(@NonNull Mint mint, @NonNull BlindedMessage blindedMessage, @NonNull MintProtocolService mintProtocolService, @NonNull SignatureVaultService signatureVaultService) {
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (blindedMessage == null) {
            throw new NullPointerException("blindedMessage is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
        this.mint = mint;
        this.blindedMessage = blindedMessage;
        this.mintProtocolService = mintProtocolService;
        this.signatureVaultService = signatureVaultService;
    }

    public BlindSignature execute() throws CashuErrorException {
        Signature sigObj;
        PrivateKey privateKey;
        if (log.isDebugEnabled()) {
            log.debug("Signing blinded message: amount={} keySetId={}", (Object)this.blindedMessage.getAmount(), (Object)this.blindedMessage.getKeySetId());
        }
        if ((privateKey = this.getPrivateKey(this.blindedMessage, this.mint)) == null) {
            ErrorResponse error = new ErrorResponse("sign_private_key_not_found");
            log.warn("Private key not found for amount={} keySetId={}", (Object)this.blindedMessage.getAmount(), (Object)this.blindedMessage.getKeySetId());
            throw new CashuErrorException(error.toJson());
        }
        byte[] signature = BDHKEUtils.signBlindedMessage((byte[])this.blindedMessage.getBlindedMessage().toBytes(), (byte[])privateKey.toBytes());
        if (log.isDebugEnabled()) {
            int len = signature == null ? -1 : signature.length;
            int first = signature != null && signature.length > 0 ? signature[0] & 0xFF : -1;
            String rawHex = signature == null ? "null" : SignBlindedMessageTask.bytesToHex(signature);
            log.debug("Raw blind signature bytes: len={} firstByte=0x{} hex={}", new Object[]{len, first < 0 ? "--" : String.format("%02x", first), rawHex});
        }
        if (signature != null && signature.length == 64) {
            sigObj = Signature.fromBytes((byte[])signature);
        } else if (signature != null && signature.length == 33 && (signature[0] == 2 || signature[0] == 3)) {
            sigObj = Signature.fromString((String)SignBlindedMessageTask.bytesToHex(signature));
        } else if (signature != null && signature.length == 33) {
            byte[] point = new byte[33];
            point[0] = 2;
            System.arraycopy(signature, 1, point, 1, 32);
            sigObj = Signature.fromString((String)SignBlindedMessageTask.bytesToHex(point));
        } else if (signature != null && signature.length == 32) {
            byte[] point = new byte[33];
            point[0] = 2;
            System.arraycopy(signature, 0, point, 1, 32);
            sigObj = Signature.fromString((String)SignBlindedMessageTask.bytesToHex(point));
        } else {
            Object hexPreview;
            Object object = hexPreview = signature == null ? "null" : SignBlindedMessageTask.bytesToHex(signature);
            if (hexPreview != null && ((String)hexPreview).length() > 24) {
                hexPreview = ((String)hexPreview).substring(0, 24) + "...";
            }
            int len = signature == null ? -1 : signature.length;
            ErrorResponse error = new ErrorResponse("invalid_blind_signature", String.format("invalid signature: len=%d hex=%s", len, hexPreview));
            throw new CashuErrorException(error.toJson());
        }
        if (log.isDebugEnabled()) {
            String hex = sigObj.toString();
            log.debug("Normalized blind signature hex={}", (Object)hex);
        }
        BlindSignature blindSignature = new BlindSignature(this.blindedMessage.getAmount(), this.blindedMessage.getKeySetId(), sigObj);
        this.signatureVaultService.store(this.blindedMessage, blindSignature);
        if (log.isDebugEnabled()) {
            log.debug("Stored blind signature for amount={} keySetId={}", (Object)this.blindedMessage.getAmount(), (Object)this.blindedMessage.getKeySetId());
        }
        return blindSignature;
    }

    private PrivateKey getPrivateKey(@NonNull BlindedMessage blindedMessage, @NonNull Mint mint) throws CashuErrorException {
        if (blindedMessage == null) {
            throw new NullPointerException("blindedMessage is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        return this.mintProtocolService.getPrivateKey(blindedMessage.getKeySetId().toString(), blindedMessage.getAmount(), mint);
    }

    private static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hexString = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            hexString.append(String.format("%02x", b & 0xFF));
        }
        return hexString.toString();
    }
}

