/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.tasks.validator.P2PKSpendingCondition;
import xyz.tcheeric.cashu.mint.proto.tasks.validator.RSSSpendingCondition;
import xyz.tcheeric.cashu.mint.proto.tasks.validator.SpendingCondition;

public class VerifyProofsTask<T extends Secret>
implements Task<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyProofsTask.class);
    private final Mint mint;
    private final PostSwapRequest<T> request;
    private final MintProtocolService mintProtocolService;

    public Void execute() throws CashuErrorException {
        log.info("Verifying proofs....");
        this.validateAmounts();
        this.verifyProofs(this.request);
        return null;
    }

    private void validateAmounts() throws CashuErrorException {
        log.debug("Validate Amounts...");
        List proofs = this.request.getInputs();
        List blindedMessages = this.request.getBlindedMessages();
        int proofsAmount = proofs.stream().mapToInt(Proof::getAmount).sum();
        int blindedMessagesAmount = blindedMessages.stream().mapToInt(BlindedMessage::getAmount).sum();
        if (proofsAmount != blindedMessagesAmount) {
            log.error("validate_amounts_error");
            ErrorResponse error = new ErrorResponse("validate_amounts_error");
            throw new CashuErrorException(error.toJson());
        }
        log.info("validate_amounts_ok");
    }

    private void verifyProofs(@NonNull PostSwapRequest<T> request) throws CashuErrorException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        log.debug("Verify proofs: {}", (Object)request.getInputs());
        List proofs = request.getInputs();
        List blindedMessages = request.getBlindedMessages();
        for (Proof proof : proofs) {
            Secret secret = proof.getSecret();
            SpendingCondition<T> spendingCondition = this.getSpendingCondition(secret, blindedMessages);
            spendingCondition.verify(proof);
        }
        log.info("Verify proofs ok");
    }

    private SpendingCondition<T> getSpendingCondition(@NonNull Secret secret, List<BlindedMessage> blindedMessages) {
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        if (secret instanceof P2PKSecret) {
            return new P2PKSpendingCondition(blindedMessages);
        }
        if (secret instanceof RandomStringSecret) {
            return new RSSSpendingCondition(this.mint, this.mintProtocolService);
        }
        throw new IllegalArgumentException("Unsupported proof type");
    }

    @Generated
    public VerifyProofsTask(Mint mint, PostSwapRequest<T> request, MintProtocolService mintProtocolService) {
        this.mint = mint;
        this.request = request;
        this.mintProtocolService = mintProtocolService;
    }
}

