/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.mint.proto.service.MintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultMintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultProofVaultService;
import xyz.tcheeric.cashu.mint.proto.util.MintProtocolUtil;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;

public class InvalidateProofsTask<T extends Secret>
implements Task<List<Proof<T>>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InvalidateProofsTask.class);
    private final Mint mint;
    private final List<Proof<T>> proofs;
    private final MintVaultService mintVaultService;
    private final ProofVaultService proofVaultService;

    public InvalidateProofsTask(@NonNull Mint mint, @NonNull List<Proof<T>> proofs) {
        this(mint, proofs, new DefaultMintVaultService(), new DefaultProofVaultService());
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
    }

    public InvalidateProofsTask(@NonNull Mint mint, @NonNull List<Proof<T>> proofs, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) {
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
        this.mint = mint;
        this.proofs = proofs;
        this.mintVaultService = mintVaultService;
        this.proofVaultService = proofVaultService;
    }

    public List<Proof<T>> execute() throws CashuErrorException {
        MintEntity mintEntity = this.mintVaultService.retrieveMint(this.mint.getId());
        for (Proof<T> proof : this.proofs) {
            ProofEntity proofEntity = MintProtocolUtil.toProofEntity(proof, mintEntity);
            this.proofVaultService.store(proofEntity);
            this.proofVaultService.invalidate(proofEntity);
        }
        return this.proofs;
    }
}

