/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks.validator;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.P2PKSecret;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.crypto.Schnorr;
import xyz.tcheeric.cashu.crypto.util.Utils;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.mint.proto.tasks.validator.SpendingCondition;

public class P2PKSpendingCondition
implements SpendingCondition<P2PKSecret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(P2PKSpendingCondition.class);
    private List<BlindedMessage> blindedMessages;

    @Override
    public void verify(@NonNull Proof<P2PKSecret> proof) throws CashuErrorException {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        log.info("Verifying P2PK spending condition for {}", proof);
        this.verifyMultisig(proof);
        this.verifyLockTime(proof);
        this.verifyRefundPublicKey(proof);
    }

    private void verifyMultisig(@NonNull Proof<P2PKSecret> proof) throws CashuErrorException {
        byte[] data;
        List signatures;
        int validSignatureCount;
        int n_sigs;
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        log.debug("verifyMultisig {}", proof);
        P2PKSecret secret = (P2PKSecret)proof.getSecret();
        int n = n_sigs = secret.getNSigs() > 0 ? secret.getNSigs() : 1;
        if (n_sigs < 0) {
            log.error("Invalid number of signatures");
            throw new IllegalArgumentException("Invalid number of signatures");
        }
        ArrayList<String> publicKeyList = new ArrayList<String>();
        publicKeyList.add(Hex.toHexString((byte[])secret.getData()));
        List secretPubkeys = secret.getPubKeys();
        if (secretPubkeys != null) {
            publicKeyList.addAll(secretPubkeys);
        }
        if ((validSignatureCount = this.getValidSignatureCount(publicKeyList, signatures = proof.getWitness().getSignatures(), data = ((P2PKSecret)proof.getSecret()).toString().getBytes())) < n_sigs) {
            log.error("verify_invalid_number_of_signatures");
            ErrorResponse error = new ErrorResponse("verify_invalid_number_of_signatures");
            throw new CashuErrorException(error.toJson());
        }
        log.info("Multisig Verification passed");
    }

    private void verifyLockTime(@NonNull Proof<P2PKSecret> proof) throws CashuErrorException {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        log.debug("verifyLockTime {}", proof);
        int lockTime = ((P2PKSecret)proof.getSecret()).getLockTime();
        if (lockTime <= 0) {
            return;
        }
        if ((long)lockTime < System.currentTimeMillis() / 1000L) {
            log.info("Locktime verification passed");
            return;
        }
        log.error("verify_locktime_not_reached");
        ErrorResponse error = new ErrorResponse("verify_locktime_not_reached");
        throw new CashuErrorException(error.toJson());
    }

    private void verifyRefundPublicKey(@NonNull Proof<P2PKSecret> proof) throws CashuErrorException {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        log.debug("verifyRefundPublicKey {}", proof);
        int lockTime = ((P2PKSecret)proof.getSecret()).getLockTime();
        if (lockTime > 0 && (long)lockTime < System.currentTimeMillis() / 1000L) {
            List refundPublicKeys = ((P2PKSecret)proof.getSecret()).getRefund();
            if (refundPublicKeys != null && !refundPublicKeys.isEmpty()) {
                byte[] secretBytes = ((P2PKSecret)proof.getSecret()).toString().getBytes();
                List signatures = proof.getWitness().getSignatures();
                String sigFlag = ((P2PKSecret)proof.getSecret()).getSigFlag();
                int validSignatureCount = this.getValidSignatureCount(refundPublicKeys, signatures, secretBytes);
                if (validSignatureCount == 0) {
                    log.error("verify_invalid_refund_signature");
                    ErrorResponse error = new ErrorResponse("verify_invalid_refund_signature");
                    throw new CashuErrorException(error.toJson());
                }
                if (P2PKSecret.SignatureFlag.valueOf((String)sigFlag).ordinal() >= 1) {
                    if (this.blindedMessages == null || this.blindedMessages.isEmpty()) {
                        log.error("BlindedMessage list is null or empty");
                        throw new IllegalStateException("BlindedMessage list is null or empty");
                    }
                    for (BlindedMessage bm : this.blindedMessages) {
                        byte[] outData;
                        if (bm.getWitness() == null) {
                            log.error("BlindedMessage witness is null");
                            throw new IllegalStateException("BlindedMessage witness is null");
                        }
                        List outSigs = bm.getWitness().getSignatures();
                        validSignatureCount = this.getValidSignatureCount(refundPublicKeys, outSigs, outData = bm.getBlindedMessage().toBytes());
                        if (validSignatureCount != 0) continue;
                        log.error("verify_invalid_refund_signature");
                        ErrorResponse error = new ErrorResponse("verify_invalid_refund_signature");
                        throw new CashuErrorException(error.toJson());
                    }
                }
                log.info("Refund Verification passed");
            } else {
                log.info("No refund public keys found. Skipping refund verification.");
            }
        } else {
            log.info("Locktime is in the future. Skipping refund verification. {}", proof);
        }
    }

    private int getValidSignatureCount(List<String> publicKeyList, List<String> signatures, byte[] data) {
        int validSignatureCount = 0;
        for (int i = 0; i < publicKeyList.size(); ++i) {
            String publicKey = publicKeyList.get(i);
            for (int j = 0; j < signatures.size(); ++j) {
                String signature = signatures.get(j);
                try {
                    log.info("Verifying data: {} - publicKey: {} - signature: {}", new Object[]{Hex.toHexString((byte[])data), publicKey, signature});
                    if (!Schnorr.verify((byte[])Utils.sha256((byte[])data), (byte[])Hex.decode((String)publicKey), (byte[])Hex.decode((String)signature))) continue;
                    log.info("Signature {} verified (Count: {})", (Object)signature, (Object)(++validSignatureCount));
                    continue;
                }
                catch (Exception e) {
                    log.warn("Error verifying signature. Continuing...", (Throwable)e);
                }
            }
        }
        return validSignatureCount;
    }

    @Generated
    public P2PKSpendingCondition(List<BlindedMessage> blindedMessages) {
        this.blindedMessages = blindedMessages;
    }

    @Generated
    public List<BlindedMessage> getBlindedMessages() {
        return this.blindedMessages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof P2PKSpendingCondition)) {
            return false;
        }
        P2PKSpendingCondition other = (P2PKSpendingCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BlindedMessage> this$blindedMessages = this.getBlindedMessages();
        List<BlindedMessage> other$blindedMessages = other.getBlindedMessages();
        return !(this$blindedMessages == null ? other$blindedMessages != null : !((Object)this$blindedMessages).equals(other$blindedMessages));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof P2PKSpendingCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BlindedMessage> $blindedMessages = this.getBlindedMessages();
        result = result * 59 + ($blindedMessages == null ? 43 : ((Object)$blindedMessages).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "P2PKSpendingCondition(blindedMessages=" + String.valueOf(this.getBlindedMessages()) + ")";
    }
}

