/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultMintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultProofVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.InvalidateProofsTask;
import xyz.tcheeric.cashu.mint.proto.util.FeeConfig;
import xyz.tcheeric.cashu.mint.proto.util.ProofLockManager;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;
import xyz.tcheeric.gateway.common.Gateway;

public class MeltTask<T extends Secret>
implements Task<PostMeltResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MeltTask.class);
    private final PostMeltRequest<T> postMeltRequest;
    private final PaymentMethod method;
    private final String unit;
    private final Mint mint;
    private final MintProtocolService mintProtocolService;
    private final MintLoadService mintLoadService;
    private final MintVaultService mintVaultService;
    private final ProofVaultService proofVaultService;

    public MeltTask(@NonNull PostMeltRequest<T> postMeltRequest, @NonNull PaymentMethod method, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService) {
        this(postMeltRequest, method, null, mint, mintProtocolService, new DefaultMintLoadService(), new DefaultMintVaultService(), new DefaultProofVaultService());
        if (postMeltRequest == null) {
            throw new NullPointerException("postMeltRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
    }

    public MeltTask(@NonNull PostMeltRequest<T> postMeltRequest, @NonNull PaymentMethod method, String unit, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService, @NonNull MintLoadService mintLoadService, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) {
        if (postMeltRequest == null) {
            throw new NullPointerException("postMeltRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
        this.postMeltRequest = postMeltRequest;
        this.method = method;
        this.unit = unit;
        this.mint = mint;
        this.mintLoadService = mintLoadService;
        this.mintProtocolService = mintProtocolService;
        this.mintVaultService = mintVaultService;
        this.proofVaultService = proofVaultService;
    }

    public MeltTask(@NonNull PostMeltRequest<T> postMeltRequest, @NonNull PaymentMethod method, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService, @NonNull MintLoadService mintLoadService, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) {
        this(postMeltRequest, method, null, mint, mintProtocolService, mintLoadService, mintVaultService, proofVaultService);
        if (postMeltRequest == null) {
            throw new NullPointerException("postMeltRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
    }

    public PostMeltResponse execute() throws CashuErrorException {
        List proofsToMelt = this.postMeltRequest.getInputs();
        try (ProofLockManager.ProofLock ignored = ProofLockManager.lockSecrets(proofsToMelt.stream().map(proof -> proof.getSecret().toString()).toList());){
            for (Proof proof2 : proofsToMelt) {
                if (this.isVoucherSecret(proof2.getSecret())) {
                    log.warn("Voucher secret rejected in melt operation (Model B enforcement)");
                    ErrorResponse error = new ErrorResponse("voucher_not_accepted", "Vouchers cannot be melted at mint (Model B). Please redeem with issuing merchant.");
                    throw new CashuErrorException(error.toJson());
                }
                if (this.verify(proof2)) continue;
                ErrorResponse error = new ErrorResponse("melt_proof_verification_error");
                throw new CashuErrorException(error.toJson());
            }
            String keySetId = ((Proof)proofsToMelt.get(0)).getKeySetId();
            KeySet keyset = this.mintLoadService.keySet(keySetId);
            String quoteId = this.postMeltRequest.getQuoteId();
            Gateway gateway = this.unit == null ? this.mintProtocolService.createGateway(this.method) : this.mintProtocolService.createGateway(this.method, this.unit);
            Integer amount = gateway.getAmount(quoteId);
            String request = gateway.getRequest(quoteId);
            Integer fee_reserve = gateway.getFeeReserve(quoteId);
            int calculated_fee_reserve = fee_reserve + (int)Math.ceil((double)amount.intValue() * FeeConfig.getFeeReservePercent());
            log.debug("Processing melt quote {} for request {} with fee reserve {}", new Object[]{quoteId, request, calculated_fee_reserve});
            int totalAmount = proofsToMelt.stream().mapToInt(proof -> proof.getAmount()).sum() + this.postMeltRequest.getFees(keyset) + calculated_fee_reserve;
            if (totalAmount < amount + fee_reserve) {
                ErrorResponse error = new ErrorResponse("melt_proof_amount_error");
                throw new CashuErrorException(error.toJson());
            }
            gateway.pay(quoteId);
            boolean paid = gateway.checkPaymentStatus(quoteId);
            if (!paid) {
                ErrorResponse error = new ErrorResponse("melt_invoice_not_paid_error");
                throw new CashuErrorException(error.toJson());
            }
            try {
                this.persistPendingProofs(proofsToMelt);
            }
            catch (RuntimeException | CashuErrorException e) {
                log.error("Failed to mark proofs as pending for melt quote {}", (Object)quoteId, (Object)e);
                ErrorResponse error = new ErrorResponse("melt_proof_pending_error");
                throw new CashuErrorException(error.toJson());
            }
            this.createInvalidateProofsTask(proofsToMelt).execute();
            PostMeltResponse postMeltResponse = new PostMeltResponse(paid, gateway.getPaymentPreimage(quoteId));
            return postMeltResponse;
        }
    }

    public boolean verify(@NonNull Proof proof) throws CashuErrorException {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        PrivateKey privateKey = this.mintProtocolService.getPrivateKey(proof.getKeySetId(), proof.getAmount(), this.mint);
        if (privateKey != null) {
            return BDHKEUtils.verify((String)proof.getSecret().toString(), (byte[])privateKey.toBytes(), (byte[])proof.getUnblindedSignature().getBytes());
        }
        return false;
    }

    private void persistPendingProofs(List<Proof<T>> proofsToMelt) throws CashuErrorException {
        MintEntity mintEntity = this.mintVaultService.retrieveMint(this.mint.getId());
        for (Proof<T> proof : proofsToMelt) {
            ProofEntity proofEntity = new ProofEntity();
            proofEntity.setAmount(Integer.valueOf(proof.getAmount()));
            proofEntity.setSecret(proof.getSecret().toString());
            if (proof.getWitness() != null) {
                proofEntity.setWitness(proof.getWitness().toString());
            }
            proofEntity.setUnblindedSignature(proof.getUnblindedSignature().toString());
            proofEntity.setMint(mintEntity);
            proofEntity.setState("PENDING");
            this.proofVaultService.storePending(proofEntity);
        }
    }

    protected InvalidateProofsTask<T> createInvalidateProofsTask(List<Proof<T>> proofs) {
        return new InvalidateProofsTask<T>(this.mint, proofs, this.mintVaultService, this.proofVaultService);
    }

    private boolean isVoucherSecret(Secret secret) {
        if (secret == null) {
            return false;
        }
        return "xyz.tcheeric.cashu.voucher.domain.VoucherSecret".equals(secret.getClass().getName());
    }
}

