/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.SignBlindedMessageTask;
import xyz.tcheeric.cashu.mint.proto.util.ThreadUtil;
import xyz.tcheeric.gateway.common.Gateway;

public class MintTask<T extends Secret>
implements Task<PostMintResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintTask.class);
    private final PostMintRequest<T> postMintRequest;
    private final PaymentMethod method;
    private final String unit;
    private final Mint mint;
    private final MintProtocolService mintProtocolService;
    private final SignatureVaultService signatureVaultService;

    public MintTask(@NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService, @NonNull SignatureVaultService signatureVaultService) {
        this(postMintRequest, method, null, mint, mintProtocolService, signatureVaultService);
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
    }

    public MintTask(@NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method, String unit, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService, @NonNull SignatureVaultService signatureVaultService) {
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
        this.postMintRequest = postMintRequest;
        this.method = method;
        this.unit = unit;
        this.mint = mint;
        this.mintProtocolService = mintProtocolService;
        this.signatureVaultService = signatureVaultService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostMintResponse execute() throws CashuErrorException {
        ThreadUtil.MINT_MELT_LOCK.lock();
        try {
            PostMintResponse result = new PostMintResponse();
            if (log.isDebugEnabled()) {
                log.debug("Starting mint task: method={} unit={} blindedMessages={}", new Object[]{this.method, this.unit, this.postMintRequest.getBlindedMessages() == null ? 0 : this.postMintRequest.getBlindedMessages().size()});
            }
            Gateway gateway = this.unit == null ? this.mintProtocolService.createGateway(this.method) : this.mintProtocolService.createGateway(this.method, this.unit);
            boolean paid = gateway.checkPaymentStatus(this.postMintRequest.getQuoteId());
            if (log.isDebugEnabled()) {
                log.debug("Payment status for quoteId={} paid={}", (Object)this.postMintRequest.getQuoteId(), (Object)paid);
            }
            if (!paid) {
                ErrorResponse error = new ErrorResponse("mint_invoice_not_paid_error");
                throw new CashuErrorException(error.toJson());
            }
            List blindedMessages = this.postMintRequest.getBlindedMessages();
            if (log.isDebugEnabled()) {
                log.debug("Signing {} blinded messages...", (Object)(blindedMessages == null ? 0 : blindedMessages.size()));
            }
            for (BlindedMessage bm : blindedMessages) {
                SignBlindedMessageTask signBlindedMessageTask = new SignBlindedMessageTask(this.mint, bm, this.mintProtocolService, this.signatureVaultService);
                BlindSignature bSignature = signBlindedMessageTask.execute();
                result.addBlindSignature(bSignature);
                if (!log.isDebugEnabled()) continue;
                log.debug("Signed blinded message amount={} keySetId={}", (Object)bm.getAmount(), (Object)bm.getKeySetId());
            }
            PostMintResponse postMintResponse = result;
            return postMintResponse;
        }
        finally {
            ThreadUtil.MINT_MELT_LOCK.unlock();
        }
    }
}

