/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.service.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;

@Service
public class DefaultSignatureVaultService
implements SignatureVaultService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSignatureVaultService.class);
    private final Map<String, BlindSignature> store = new ConcurrentHashMap<String, BlindSignature>();

    @Override
    public void store(BlindedMessage message, BlindSignature signature) throws CashuErrorException {
        if (message == null || signature == null) {
            throw new CashuErrorException("store_invalid_arguments");
        }
        String key = message.getBlindedMessage().toString();
        this.store.put(key, signature);
        log.debug("Signature stored: keyset={}, amount={}, vault_size={}", new Object[]{signature.getKeySetId(), signature.getAmount(), this.store.size()});
    }

    @Override
    public BlindSignature retrieve(BlindedMessage message) throws CashuErrorException {
        if (message == null) {
            throw new CashuErrorException("retrieve_invalid_arguments");
        }
        String key = message.getBlindedMessage().toString();
        BlindSignature signature = this.store.get(key);
        if (signature != null) {
            log.trace("Signature retrieved: keyset={}, amount={}", (Object)signature.getKeySetId(), (Object)signature.getAmount());
        } else {
            log.trace("Signature not found for blinded message (possible gap in NUT-13 recovery)");
        }
        return signature;
    }
}

