/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Keys;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.crypto.util.KeySetDerivation;
import xyz.tcheeric.cashu.vault.api.db.impl.DBKeySetVault;
import xyz.tcheeric.cashu.vault.api.db.impl.DBKeyVault;
import xyz.tcheeric.cashu.vault.db.model.KeySetEntity;

public class KeysetGeneratorTask
implements Task<KeySet> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeysetGeneratorTask.class);
    private final String mintId;
    private final String unit;

    public KeySet execute() throws CashuErrorException {
        log.info("execute()");
        Keys keys = this.getKeys();
        log.info("Keys: {}", (Object)keys);
        KeySet keySet = KeySet.builder().unit(this.unit).keys(keys).build();
        keySet.setId(KeySetDerivation.getId((Map)keys.values()));
        return keySet;
    }

    private Keys getKeys() throws CashuErrorException {
        log.info("getKeys()");
        KeySetEntity keySetEntity = new DBKeySetVault().retrieveByMintIdAndUnit(this.mintId, this.unit);
        return DBKeyVault.load((KeySetEntity)keySetEntity);
    }

    @Generated
    public KeysetGeneratorTask(String mintId, String unit) {
        this.mintId = mintId;
        this.unit = unit;
    }
}

