/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultMintLoadService;

public class LoadKeySetTask
implements Task<KeySet> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadKeySetTask.class);
    private final String keysetId;
    private final MintLoadService mintLoadService;

    public LoadKeySetTask(@NonNull String keysetId) {
        this(keysetId, new DefaultMintLoadService());
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
    }

    public LoadKeySetTask(@NonNull String keysetId, @NonNull MintLoadService mintLoadService) {
        if (keysetId == null) {
            throw new NullPointerException("keysetId is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        this.keysetId = keysetId;
        this.mintLoadService = mintLoadService;
    }

    public KeySet execute() throws CashuErrorException {
        List<KeySet> keySets = this.mintLoadService.keySets();
        log.debug("keysets: {}", keySets);
        return keySets.stream().filter(keySet -> null != keySet.getId()).filter(keySet -> keySet.getId().equals(this.keysetId)).findFirst().orElseThrow();
    }
}

