/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.SplittingService;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.SignBlindedMessageTask;
import xyz.tcheeric.cashu.mint.proto.util.ThreadUtil;
import xyz.tcheeric.gateway.common.Gateway;

public class MintTask<T extends Secret>
implements Task<PostMintResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintTask.class);
    private final PostMintRequest<T> postMintRequest;
    private final PaymentMethod method;
    private final String unit;
    private final Mint mint;
    private final MintProtocolService mintProtocolService;
    private final SignatureVaultService signatureVaultService;
    private final SplittingService splittingService = new SplittingService();

    public MintTask(@NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService, @NonNull SignatureVaultService signatureVaultService) {
        this(postMintRequest, method, null, mint, mintProtocolService, signatureVaultService);
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
    }

    public MintTask(@NonNull PostMintRequest<T> postMintRequest, @NonNull PaymentMethod method, String unit, @NonNull Mint mint, @NonNull MintProtocolService mintProtocolService, @NonNull SignatureVaultService signatureVaultService) {
        if (postMintRequest == null) {
            throw new NullPointerException("postMintRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
        this.postMintRequest = postMintRequest;
        this.method = method;
        this.unit = unit;
        this.mint = mint;
        this.mintProtocolService = mintProtocolService;
        this.signatureVaultService = signatureVaultService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostMintResponse execute() throws CashuErrorException {
        ThreadUtil.MINT_MELT_LOCK.lock();
        try {
            PostMintResponse result = new PostMintResponse();
            if (log.isDebugEnabled()) {
                log.debug("Starting mint task: method={} unit={} blindedMessages={}", new Object[]{this.method, this.unit, this.postMintRequest.getBlindedMessages() == null ? 0 : this.postMintRequest.getBlindedMessages().size()});
            }
            Gateway gateway = this.unit == null ? this.mintProtocolService.createGateway(this.method) : this.mintProtocolService.createGateway(this.method, this.unit);
            boolean paid = gateway.checkPaymentStatus(this.postMintRequest.getQuoteId());
            if (log.isDebugEnabled()) {
                log.debug("Payment status for quoteId={} paid={}", (Object)this.postMintRequest.getQuoteId(), (Object)paid);
            }
            if (!paid) {
                ErrorResponse error = new ErrorResponse("mint_invoice_not_paid_error");
                throw new CashuErrorException(error.toJson());
            }
            List blindedMessages = this.postMintRequest.getBlindedMessages();
            this.validateDenominations(blindedMessages, this.mint);
            if (log.isDebugEnabled()) {
                log.debug("Signing {} blinded messages...", (Object)(blindedMessages == null ? 0 : blindedMessages.size()));
            }
            for (BlindedMessage bm : blindedMessages) {
                SignBlindedMessageTask signBlindedMessageTask = new SignBlindedMessageTask(this.mint, bm, this.mintProtocolService, this.signatureVaultService);
                BlindSignature bSignature = signBlindedMessageTask.execute();
                result.addBlindSignature(bSignature);
                if (!log.isDebugEnabled()) continue;
                log.debug("Signed blinded message amount={} keySetId={}", (Object)bm.getAmount(), (Object)bm.getKeySetId());
            }
            PostMintResponse postMintResponse = result;
            return postMintResponse;
        }
        finally {
            ThreadUtil.MINT_MELT_LOCK.unlock();
        }
    }

    private void validateDenominations(List<BlindedMessage> blindedMessages, Mint mint) throws CashuErrorException {
        if (blindedMessages == null || blindedMessages.isEmpty()) {
            throw new CashuErrorException("mint_request_missing_outputs");
        }
        HashMap<String, List> outputsByKeyset = new HashMap<String, List>();
        for (BlindedMessage blindedMessage : blindedMessages) {
            if (blindedMessage == null) {
                throw new CashuErrorException("mint_request_contains_null_output");
            }
            if (blindedMessage.getKeySetId() == null) {
                throw new CashuErrorException("missing_keyset_id");
            }
            int amount = blindedMessage.getAmount();
            if (amount <= 0) {
                throw new CashuErrorException("invalid_output_amount");
            }
            outputsByKeyset.computeIfAbsent(blindedMessage.getKeySetId().toString(), ignored -> new ArrayList()).add(amount);
        }
        for (Map.Entry entry : outputsByKeyset.entrySet()) {
            List expected;
            String keysetId = (String)entry.getKey();
            KeySet keySet = this.findKeySet(mint, keysetId);
            Set availableDenoms = keySet.getKeys() == null ? Set.of() : keySet.getKeys().getValues().keySet().stream().map(BigInteger::intValue).filter(value -> value > 0).collect(Collectors.toSet());
            long total = ((List)entry.getValue()).stream().mapToLong(Integer::longValue).sum();
            try {
                expected = this.splittingService.split(total, availableDenoms);
            }
            catch (IllegalStateException e) {
                throw new CashuErrorException("invalid_denominations");
            }
            ArrayList actual = new ArrayList((Collection)entry.getValue());
            actual.sort(Comparator.reverseOrder());
            if (actual.equals(expected)) continue;
            throw new CashuErrorException("invalid_denominations");
        }
    }

    private KeySet findKeySet(Mint mint, String keysetId) throws CashuErrorException {
        return mint.getKeySets().stream().filter(keySet -> keysetId.equals(keySet.getId())).findFirst().orElseThrow(() -> new CashuErrorException("keyset_not_found"));
    }
}

