/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostRestoreRequest;
import xyz.tcheeric.cashu.entities.rest.PostRestoreResponse;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;

public class RestoreSignaturesTask
implements Task<PostRestoreResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestoreSignaturesTask.class);
    private final PostRestoreRequest request;
    private final SignatureVaultService signatureVaultService;

    public RestoreSignaturesTask(@NonNull PostRestoreRequest request, @NonNull SignatureVaultService signatureVaultService) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (signatureVaultService == null) {
            throw new NullPointerException("signatureVaultService is marked non-null but is null");
        }
        this.request = request;
        this.signatureVaultService = signatureVaultService;
    }

    public PostRestoreResponse execute() throws CashuErrorException {
        int requestedCount = this.request.getBlindedMessages().size();
        log.debug("NUT-09 restore request received: {} blinded messages", (Object)requestedCount);
        ArrayList<BlindedMessage> outputs = new ArrayList<BlindedMessage>();
        ArrayList<BlindSignature> signatures = new ArrayList<BlindSignature>();
        int foundCount = 0;
        int notFoundCount = 0;
        for (BlindedMessage bm : this.request.getBlindedMessages()) {
            BlindSignature sig2 = this.signatureVaultService.retrieve(bm);
            if (sig2 != null) {
                outputs.add(bm);
                signatures.add(sig2);
                ++foundCount;
                continue;
            }
            ++notFoundCount;
        }
        log.info("NUT-09 restore completed: {}/{} signatures found (matches={}, gaps={})", new Object[]{foundCount, requestedCount, foundCount, notFoundCount});
        if (foundCount > 0) {
            log.debug("NUT-09 recovered signatures for keysets: {}", signatures.stream().map(sig -> sig.getKeySetId().toString()).distinct().toList());
        }
        return new PostRestoreResponse(outputs, signatures);
    }
}

