/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.nut;

import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.entities.annotation.Nut;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultMintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.tasks.MeltQuoteStatusTask;
import xyz.tcheeric.cashu.mint.proto.tasks.MeltQuoteTask;
import xyz.tcheeric.cashu.mint.proto.tasks.MeltTokensTask;

@Nut(value=5, description="Melt tokens")
public class NUT05 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NUT05.class);

    public static PostMeltQuoteResponse quote(@NonNull PostMeltQuoteRequest postMeltQuoteRequest, @NonNull PaymentMethod method) {
        if (postMeltQuoteRequest == null) {
            throw new NullPointerException("postMeltQuoteRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return NUT05.quote(postMeltQuoteRequest, method, null, MintProtocolServiceFactory.getInstance());
    }

    public static PostMeltQuoteResponse quote(@NonNull PostMeltQuoteRequest postMeltQuoteRequest, @NonNull PaymentMethod method, String unit, @NonNull MintProtocolService mintProtocolService) {
        if (postMeltQuoteRequest == null) {
            throw new NullPointerException("postMeltQuoteRequest is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        try {
            return new MeltQuoteTask(postMeltQuoteRequest, method, unit, mintProtocolService).execute();
        }
        catch (CashuErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public static PostMeltQuoteResponse quotePaymentStatus(@NonNull String quoteId, @NonNull PaymentMethod method) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return NUT05.quotePaymentStatus(quoteId, method, null, MintProtocolServiceFactory.getInstance());
    }

    public static PostMeltQuoteResponse quotePaymentStatus(@NonNull String quoteId, @NonNull PaymentMethod method, String unit, @NonNull MintProtocolService mintProtocolService) {
        if (quoteId == null) {
            throw new NullPointerException("quoteId is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        try {
            return new MeltQuoteStatusTask(quoteId, method, unit, mintProtocolService).execute();
        }
        catch (CashuErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Secret> PostMeltResponse melt(@NonNull UUID mintId, @NonNull PostMeltRequest<T> request, @NonNull PaymentMethod method) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return NUT05.melt(mintId, request, method, null, MintProtocolServiceFactory.getInstance(), new DefaultMintLoadService(), new DefaultMintVaultService(), new DefaultProofVaultService());
    }

    public static <T extends Secret> PostMeltResponse melt(@NonNull UUID mintId, @NonNull PostMeltRequest<T> request, @NonNull PaymentMethod method, String unit) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        return NUT05.melt(mintId, request, method, unit, MintProtocolServiceFactory.getInstance(), new DefaultMintLoadService(), new DefaultMintVaultService(), new DefaultProofVaultService());
    }

    public static <T extends Secret> PostMeltResponse melt(@NonNull UUID mintId, @NonNull PostMeltRequest<T> request, @NonNull PaymentMethod method, String unit, @NonNull MintProtocolService mintProtocolService, @NonNull MintLoadService mintLoadService, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        if (mintLoadService == null) {
            throw new NullPointerException("mintLoadService is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
        return new MeltTokensTask<T>(mintId, request, method, unit, mintProtocolService, mintLoadService, mintVaultService, proofVaultService).execute();
    }

    public static <T extends Secret> PostMeltResponse melt(@NonNull UUID mintId, @NonNull PostMeltRequest<T> request, @NonNull PaymentMethod method, @NonNull MintVaultService mintVaultService, @NonNull ProofVaultService proofVaultService) throws CashuErrorException {
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintVaultService == null) {
            throw new NullPointerException("mintVaultService is marked non-null but is null");
        }
        if (proofVaultService == null) {
            throw new NullPointerException("proofVaultService is marked non-null but is null");
        }
        return NUT05.melt(mintId, request, method, null, MintProtocolServiceFactory.getInstance(), new DefaultMintLoadService(), mintVaultService, proofVaultService);
    }
}

