/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.util.CashuErrorException;

public interface MintLoadService {
    public Mint load(UUID var1, boolean var2) throws CashuErrorException;

    default public Mint load(String mintId, boolean archive) throws CashuErrorException {
        return this.load(UUID.fromString(mintId), archive);
    }

    public List<Mint> load(boolean var1) throws CashuErrorException;

    default public List<KeySet> keySets() throws CashuErrorException {
        ArrayList<KeySet> result = new ArrayList<KeySet>();
        result.addAll(this.keySets(false));
        result.addAll(this.keySets(true));
        return result;
    }

    default public KeySet keySet(@NonNull String keySetId) throws CashuErrorException {
        if (keySetId == null) {
            throw new NullPointerException("keySetId is marked non-null but is null");
        }
        return this.keySets().stream().filter(keySet -> keySetId.equals(keySet.getId())).findFirst().orElse(null);
    }

    default public List<KeySet> keySets(boolean archive) throws CashuErrorException {
        ArrayList<KeySet> result = new ArrayList<KeySet>();
        List<Mint> mints = this.load(archive);
        if (mints != null) {
            for (Mint mint : mints) {
                result.addAll(mint.getKeySets());
            }
        }
        return result;
    }
}

