/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks.validator;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.crypto.BDHKEUtils;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultProofVaultService;
import xyz.tcheeric.cashu.mint.proto.tasks.validator.SpendingCondition;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;

public class RSSSpendingCondition
implements SpendingCondition<RandomStringSecret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RSSSpendingCondition.class);
    private final Mint mint;
    private final MintProtocolService mintProtocolService;
    private final ProofVaultService proofVaultService;

    public RSSSpendingCondition(@NonNull Mint mint, @NonNull MintProtocolService mintProtocolService) {
        this(mint, mintProtocolService, new DefaultProofVaultService());
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
    }

    @Override
    public void verify(Proof<RandomStringSecret> proof) throws CashuErrorException {
        ProofEntity proofEntity;
        log.debug("Verify proof {}", proof);
        Secret secret = proof.getSecret();
        try {
            proofEntity = this.proofVaultService.retrieveProof(secret.toString());
        }
        catch (Exception e) {
            log.warn("Failed to retrieve proof for secret {}: {}", new Object[]{secret, e.getMessage(), e});
            proofEntity = null;
        }
        log.debug("Proof entity {}...", (Object)proofEntity);
        if (proofEntity != null) {
            log.error("verify_proof_already_used_error");
            ErrorResponse error = new ErrorResponse("verify_proof_already_used_error");
            throw new CashuErrorException(error.toJson());
        }
        log.debug("The proof has not yet been used...");
        if (proof.getKeySetId() == null || proof.getKeySetId().isBlank()) {
            log.error("verify_proof_key_set_id_error");
            ErrorResponse error = new ErrorResponse("verify_proof_key_set_id_error");
            throw new CashuErrorException(error.toJson());
        }
        log.debug("The proof key set id is valid...");
        PrivateKey privateKey = this.getPrivateKey(proof, this.mint);
        if (privateKey == null) {
            log.error("verify_proof_key_set_not_found");
            ErrorResponse error = new ErrorResponse("verify_proof_key_set_not_found");
            throw new CashuErrorException(error.toJson());
        }
        byte[] C = proof.getUnblindedSignature().getBytes();
        if (!BDHKEUtils.verify((String)secret.toString(), (byte[])privateKey.toBytes(), (byte[])C)) {
            log.error("verify_proof_failed_error");
            ErrorResponse error = new ErrorResponse("verify_proof_failed_error");
            throw new CashuErrorException(error.toJson());
        }
    }

    private PrivateKey getPrivateKey(@NonNull Proof<RandomStringSecret> proof, @NonNull Mint mint) throws CashuErrorException {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        log.debug("Getting private key for {}", proof);
        return this.mintProtocolService.getPrivateKey(proof.getKeySetId(), proof.getAmount(), mint);
    }

    @Generated
    public RSSSpendingCondition(Mint mint, MintProtocolService mintProtocolService, ProofVaultService proofVaultService) {
        this.mint = mint;
        this.mintProtocolService = mintProtocolService;
        this.proofVaultService = proofVaultService;
    }
}

