/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class ProofLockManager {
    private static final ConcurrentHashMap<String, ProofMutex> LOCKS = new ConcurrentHashMap();

    private ProofLockManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProofLock lockSecrets(Collection<String> secrets) {
        if (secrets == null || secrets.isEmpty()) {
            return () -> {};
        }
        TreeSet<String> uniqueSecrets = new TreeSet<String>();
        for (String secret : secrets) {
            if (secret == null) continue;
            uniqueSecrets.add(secret);
        }
        if (uniqueSecrets.isEmpty()) {
            return () -> {};
        }
        ArrayList<LockEntry> acquired = new ArrayList<LockEntry>(uniqueSecrets.size());
        boolean success = false;
        try {
            for (String secret : uniqueSecrets) {
                ProofMutex mutex = ProofLockManager.incrementReference(secret);
                mutex.lock.lock();
                acquired.add(new LockEntry(secret, mutex));
            }
            success = true;
            if (success) return () -> {
                for (int i = acquired.size() - 1; i >= 0; --i) {
                    LockEntry entry = (LockEntry)acquired.get(i);
                    entry.mutex.lock.unlock();
                    ProofLockManager.decrementReference(entry.secret, entry.mutex);
                }
            };
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            for (int i = acquired.size() - 1; i >= 0; --i) {
                LockEntry entry = (LockEntry)acquired.get(i);
                entry.mutex.lock.unlock();
                ProofLockManager.decrementReference(entry.secret, entry.mutex);
            }
            throw throwable;
        }
        for (int i = acquired.size() - 1; i >= 0; --i) {
            LockEntry entry = (LockEntry)acquired.get(i);
            entry.mutex.lock.unlock();
            ProofLockManager.decrementReference(entry.secret, entry.mutex);
        }
        return () -> {
            for (int i = acquired.size() - 1; i >= 0; --i) {
                LockEntry entry = (LockEntry)acquired.get(i);
                entry.mutex.lock.unlock();
                ProofLockManager.decrementReference(entry.secret, entry.mutex);
            }
        };
    }

    private static ProofMutex incrementReference(String secret) {
        return LOCKS.compute(secret, (key, existing) -> {
            ProofMutex mutex = existing;
            if (mutex == null) {
                mutex = new ProofMutex();
            }
            ++mutex.referenceCount;
            return mutex;
        });
    }

    private static void decrementReference(String secret, ProofMutex mutex) {
        LOCKS.computeIfPresent(secret, (key, existing) -> {
            if (existing != mutex) {
                return existing;
            }
            --existing.referenceCount;
            if (existing.referenceCount <= 0) {
                return null;
            }
            return existing;
        });
    }

    @FunctionalInterface
    public static interface ProofLock
    extends AutoCloseable {
        @Override
        public void close();
    }

    private static final class ProofMutex {
        private final ReentrantLock lock = new ReentrantLock();
        private int referenceCount;

        private ProofMutex() {
        }
    }

    private static final class LockEntry {
        private final String secret;
        private final ProofMutex mutex;

        private LockEntry(String secret, ProofMutex mutex) {
            this.secret = secret;
            this.mutex = mutex;
        }
    }
}

