/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.util;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VoucherFeeCalculator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherFeeCalculator.class);

    private VoucherFeeCalculator() {
    }

    public static long calculateFee(long voucherAmount, double feePercentage) {
        if (voucherAmount < 0L) {
            throw new IllegalArgumentException(String.format("Voucher amount cannot be negative: %d", voucherAmount));
        }
        if (feePercentage < 0.0) {
            throw new IllegalArgumentException(String.format("Fee percentage cannot be negative: %.2f", feePercentage));
        }
        if (voucherAmount == 0L || feePercentage == 0.0) {
            log.debug("Calculated voucher fee: amount={}, percentage={}%, fee=0 (zero input)", (Object)voucherAmount, (Object)feePercentage);
            return 0L;
        }
        double feeDouble = (double)voucherAmount * feePercentage / 100.0;
        if (feeDouble > 9.223372036854776E18) {
            throw new ArithmeticException(String.format("Voucher amount %d with fee percentage %.2f%% would cause overflow (result: %.0f > Long.MAX_VALUE)", voucherAmount, feePercentage, feeDouble));
        }
        long fee = (long)Math.floor(feeDouble);
        log.debug("Calculated voucher fee: amount={}, percentage={}%, fee={}", new Object[]{voucherAmount, feePercentage, fee});
        return fee;
    }
}

