/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VoucherFeeConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherFeeConfig.class);
    private static final String PROPERTY_KEY = "voucher.quote.fee-percent";
    private static final String PROPERTY_MAX_KEY = "voucher.quote.fee-percent.max";
    private static final String ENV_KEY = "VOUCHER_QUOTE_FEE_PERCENT";
    private static final String ENV_MAX_KEY = "VOUCHER_QUOTE_FEE_PERCENT_MAX";
    private static final String SYSTEM_PROP_KEY = "voucher.quote.fee-percent";
    private static final String SYSTEM_PROP_MAX_KEY = "voucher.quote.fee-percent.max";
    private static final double DEFAULT_PERCENTAGE = 10.0;
    private static final double DEFAULT_MAX_PERCENTAGE = 100.0;
    private static final Properties PROPERTIES = new Properties();
    private static Double cachedPercentage = null;
    private static Double cachedMaxPercentage = null;

    private VoucherFeeConfig() {
    }

    public static double getFeePercentage() {
        if (cachedPercentage != null) {
            return cachedPercentage;
        }
        double percentage = VoucherFeeConfig.loadPercentage();
        VoucherFeeConfig.validatePercentage(percentage);
        cachedPercentage = percentage;
        log.info("Voucher mint quote fee percentage: {}%", (Object)percentage);
        return percentage;
    }

    public static double getMaxPercentage() {
        if (cachedMaxPercentage != null) {
            return cachedMaxPercentage;
        }
        double maxPercentage = VoucherFeeConfig.loadMaxPercentage();
        cachedMaxPercentage = maxPercentage;
        log.debug("Voucher mint quote maximum fee percentage: {}%", (Object)maxPercentage);
        return maxPercentage;
    }

    private static void validatePercentage(double percentage) {
        if (percentage < 0.0) {
            throw new IllegalArgumentException(String.format("Voucher fee percentage cannot be negative: %.2f", percentage));
        }
        double max = VoucherFeeConfig.getMaxPercentage();
        if (percentage > max) {
            throw new IllegalArgumentException(String.format("Voucher fee percentage %.2f exceeds maximum %.2f", percentage, max));
        }
    }

    private static double loadPercentage() {
        String propertyValue;
        String envVar;
        String systemProp = System.getProperty("voucher.quote.fee-percent");
        if (systemProp != null) {
            try {
                double value = Double.parseDouble(systemProp);
                log.debug("Loaded voucher fee percentage from system property: {}%", (Object)value);
                return value;
            }
            catch (NumberFormatException e) {
                log.warn("Invalid system property value for {}: {}", (Object)"voucher.quote.fee-percent", (Object)systemProp);
            }
        }
        if ((envVar = System.getenv(ENV_KEY)) != null) {
            try {
                double value = Double.parseDouble(envVar);
                log.debug("Loaded voucher fee percentage from environment variable: {}%", (Object)value);
                return value;
            }
            catch (NumberFormatException e) {
                log.warn("Invalid environment variable value for {}: {}", (Object)ENV_KEY, (Object)envVar);
            }
        }
        if ((propertyValue = PROPERTIES.getProperty("voucher.quote.fee-percent")) != null) {
            try {
                double value = Double.parseDouble(propertyValue);
                log.debug("Loaded voucher fee percentage from property file: {}%", (Object)value);
                return value;
            }
            catch (NumberFormatException e) {
                log.warn("Invalid property file value for {}: {}", (Object)"voucher.quote.fee-percent", (Object)propertyValue);
            }
        }
        log.debug("Using default voucher fee percentage: {}%", (Object)10.0);
        return 10.0;
    }

    private static double loadMaxPercentage() {
        String propertyValue;
        String envVar;
        String systemProp = System.getProperty("voucher.quote.fee-percent.max");
        if (systemProp != null) {
            try {
                return Double.parseDouble(systemProp);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid system property value for {}: {}", (Object)"voucher.quote.fee-percent.max", (Object)systemProp);
            }
        }
        if ((envVar = System.getenv(ENV_MAX_KEY)) != null) {
            try {
                return Double.parseDouble(envVar);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid environment variable value for {}: {}", (Object)ENV_MAX_KEY, (Object)envVar);
            }
        }
        if ((propertyValue = PROPERTIES.getProperty("voucher.quote.fee-percent.max")) != null) {
            try {
                return Double.parseDouble(propertyValue);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid property file value for {}: {}", (Object)"voucher.quote.fee-percent.max", (Object)propertyValue);
            }
        }
        return 100.0;
    }

    static {
        try (InputStream input = VoucherFeeConfig.class.getClassLoader().getResourceAsStream("proto.properties");){
            if (input != null) {
                PROPERTIES.load(input);
            }
        }
        catch (IOException e) {
            log.warn("Failed to load proto.properties, using defaults", (Throwable)e);
        }
    }
}

