/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.service.impl;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.SecretUtil;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.vault.api.db.impl.DBProofVault;
import xyz.tcheeric.cashu.vault.db.model.ProofEntity;

@Service
public class DefaultProofVaultService
implements ProofVaultService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultProofVaultService.class);

    @Override
    public void store(ProofEntity proofEntity) throws CashuErrorException {
        DBProofVault vault = new DBProofVault();
        vault.store(proofEntity);
    }

    @Override
    public void invalidate(ProofEntity proofEntity) throws CashuErrorException {
        DBProofVault vault = new DBProofVault();
        vault.invalidate(proofEntity.getId().toString());
    }

    @Override
    public void archive(ProofEntity proofEntity) throws CashuErrorException {
        DBProofVault vault = new DBProofVault();
        vault.archive(proofEntity.getId().toString());
    }

    @Override
    public void storePending(ProofEntity proofEntity) throws CashuErrorException {
        DBProofVault vault = new DBProofVault();
        vault.storePending(proofEntity);
    }

    @Override
    public ProofEntity retrieveProof(String secret) throws CashuErrorException {
        try {
            String normalizedSecret = SecretUtil.toYFromString((String)secret);
            return DBProofVault.retrieveProof((String)normalizedSecret);
        }
        catch (CashuErrorException e) {
            log.warn("DefaultProofVaultService: failed to retrieve proof for secret {}: {}", (Object)secret, (Object)e.getMessage());
            return null;
        }
    }
}

