/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.cashu.mint.proto.nut.NUT02;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;

public class VerifyFeesTask<T extends Secret>
implements Task<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerifyFeesTask.class);
    private final PostSwapRequest<T> request;
    private final PostSwapResponse response;
    private final MintLoadService mintLoadService;

    public Void execute() throws CashuErrorException {
        this.validateFees();
        return null;
    }

    private void validateFees() throws CashuErrorException {
        int sum_outputs;
        String keySetId = ((Proof)this.request.getInputs().get(0)).getKeySetId();
        KeySet keySet = NUT02.keys(keySetId, this.mintLoadService);
        int fees = this.request.getFees(keySet);
        int sum_inputs = this.request.getInputs().stream().mapToInt(proof -> proof.getAmount()).sum();
        if (sum_inputs - fees != (sum_outputs = this.response.getBlindSignatures().stream().mapToInt(blindSignature -> blindSignature.getAmount()).sum())) {
            ErrorResponse error = new ErrorResponse("validate_fees_error");
            throw new CashuErrorException(error.toJson());
        }
    }

    @Generated
    public VerifyFeesTask(PostSwapRequest<T> request, PostSwapResponse response, MintLoadService mintLoadService) {
        this.request = request;
        this.response = response;
        this.mintLoadService = mintLoadService;
    }
}

