/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.tasks;

import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.util.Task;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.impl.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.util.VoucherFeeCalculator;
import xyz.tcheeric.cashu.mint.proto.util.VoucherFeeConfig;
import xyz.tcheeric.cashu.mint.proto.util.VoucherQuoteRegistry;
import xyz.tcheeric.gateway.common.Gateway;

public class VoucherMintQuoteTask
implements Task<PostMintQuoteResponse> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherMintQuoteTask.class);
    private final int faceValue;
    private final PaymentMethod method;
    private final String unit;
    private final MintProtocolService mintProtocolService;

    public VoucherMintQuoteTask(int faceValue, @NonNull PaymentMethod method) {
        this(faceValue, method, null, MintProtocolServiceFactory.getInstance());
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
    }

    public VoucherMintQuoteTask(int faceValue, @NonNull PaymentMethod method, String unit, @NonNull MintProtocolService mintProtocolService) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
        this.faceValue = faceValue;
        this.method = method;
        this.unit = unit;
        this.mintProtocolService = mintProtocolService;
    }

    public VoucherMintQuoteTask(int faceValue, @NonNull PaymentMethod method, @NonNull MintProtocolService mintProtocolService) {
        this(faceValue, method, null, mintProtocolService);
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (mintProtocolService == null) {
            throw new NullPointerException("mintProtocolService is marked non-null but is null");
        }
    }

    public PostMintQuoteResponse execute() {
        log.info("Creating voucher mint quote: faceValue={}, method={}", (Object)this.faceValue, (Object)this.method);
        double feePercentage = VoucherFeeConfig.getFeePercentage();
        long voucherPrice = VoucherFeeCalculator.calculateFee(this.faceValue, feePercentage);
        log.info("Voucher mint quote: faceValue={}, feePercent={}%, chargedPrice={}, method={}", new Object[]{this.faceValue, feePercentage, voucherPrice, this.method});
        Gateway gateway = this.unit == null ? this.mintProtocolService.createGateway(this.method) : this.mintProtocolService.createGateway(this.method, this.unit);
        String quoteId = gateway.createMintQuote(Integer.valueOf((int)voucherPrice), null);
        VoucherQuoteRegistry.storeFaceValue(quoteId, this.faceValue);
        String request = gateway.getRequest(quoteId);
        Integer expiry = gateway.getPaymentExpiry(quoteId);
        log.debug("Voucher mint quote created: quoteId={}, request={}, expiry={}", new Object[]{quoteId, request, expiry});
        return PostMintQuoteResponse.builder().quoteId(quoteId).request(request).expiry(expiry.intValue()).build();
    }
}

