/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.proto.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VoucherQuoteRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherQuoteRegistry.class);
    private static final Map<String, Long> faceValues = new ConcurrentHashMap<String, Long>();

    private VoucherQuoteRegistry() {
    }

    public static void storeFaceValue(String quoteId, long faceValue) {
        faceValues.put(quoteId, faceValue);
        log.debug("Stored voucher face value for quote {}: {} sats", (Object)quoteId, (Object)faceValue);
    }

    public static Long getFaceValue(String quoteId) {
        return faceValues.get(quoteId);
    }

    public static void removeFaceValue(String quoteId) {
        Long removed = faceValues.remove(quoteId);
        if (removed != null) {
            log.debug("Removed voucher face value for quote {}: {} sats", (Object)quoteId, (Object)removed);
        }
    }

    public static boolean isVoucherQuote(String quoteId) {
        return faceValues.containsKey(quoteId);
    }

    public static int size() {
        return faceValues.size();
    }

    public static void clear() {
        int size = faceValues.size();
        faceValues.clear();
        if (size > 0) {
            log.warn("Cleared {} voucher quote entries from registry", (Object)size);
        }
    }
}

