/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.entity.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.entities.rest.ActiveKeySetResponse;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.KeySetResponse;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.cashu.mint.proto.nut.NUT02;
import xyz.tcheeric.cashu.mint.proto.nut.NUT03;
import xyz.tcheeric.cashu.mint.proto.nut.NUT04;
import xyz.tcheeric.cashu.mint.proto.nut.NUT05;
import xyz.tcheeric.cashu.mint.proto.nut.NUT06;
import xyz.tcheeric.cashu.mint.proto.nut.NUT07;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintInfoService;
import xyz.tcheeric.cashu.mint.proto.service.DefaultMintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintInfoService;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.util.MintInfo;

@RestController
@RequestMapping(value={"/v1"})
public class CashuController<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CashuController.class);
    private final NUT06 nut06;
    private final MintLoadService mintLoadService;

    public CashuController() {
        this(new NUT06((MintInfoService)new DefaultMintInfoService(new MintInfo())), (MintLoadService)new DefaultMintLoadService());
    }

    public CashuController(NUT06 nut06, MintLoadService mintLoadService) {
        this.nut06 = nut06;
        this.mintLoadService = mintLoadService;
    }

    @GetMapping(value={"/keys/{mint_id}/generate"})
    public ResponseEntity<KeySetResponse> generateKeySetIds(@PathVariable(value="mint_id") String mintId) throws CashuErrorException {
        log.debug("Getting keys");
        KeySetResponse response = new KeySetResponse(NUT02.keys((UUID)UUID.fromString(mintId)));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/keys/keyset/{keyset_id}"})
    public ResponseEntity<KeySetResponse> keyset(@PathVariable(value="keyset_id") String keysetId) throws CashuErrorException {
        log.debug("keys({})", (Object)keysetId);
        KeySet keySet = NUT02.keys((String)keysetId, (MintLoadService)this.mintLoadService);
        KeySetResponse response = new KeySetResponse(List.of(keySet));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/keysets"})
    public ResponseEntity<ActiveKeySetResponse> keysets() throws CashuErrorException {
        List activeKeySets = NUT02.activeKeySets((MintLoadService)this.mintLoadService);
        ActiveKeySetResponse response = new ActiveKeySetResponse(activeKeySets);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/swap/{mint_id}"})
    public ResponseEntity<PostSwapResponse> swap(@PathVariable(value="mint_id") String mintId, @RequestBody PostSwapRequest<T> request) throws CashuErrorException {
        PostSwapResponse response = NUT03.swap((UUID)UUID.fromString(mintId), request);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/mint/quote/{method}"})
    public ResponseEntity<PostMintQuoteResponse> quoteMint(@RequestBody PostMintQuoteRequest request, @PathVariable(value="method") String method) {
        PostMintQuoteResponse response = NUT04.quote((int)request.getAmount(), (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/mint/quote/{method}/{quote_id}"})
    public ResponseEntity<PostMintQuoteResponse> quoteMint(@PathVariable(value="method") String method, @PathVariable(value="quote_id") String quoteId) {
        PostMintQuoteResponse response = NUT04.quotePaymentStatus((String)quoteId, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/mint/{mintId}/{method}"})
    public ResponseEntity<PostMintResponse> mint(@RequestBody PostMintRequest<T> request, @PathVariable(value="method") String method, @PathVariable(value="mintId") String mintId) throws CashuErrorException {
        PostMintResponse response = NUT04.mint((UUID)UUID.fromString(mintId), request, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/melt/quote/{method}"})
    public ResponseEntity<PostMeltQuoteResponse> quoteMelt(@RequestBody PostMeltQuoteRequest request, @PathVariable(value="method") String method) {
        PostMeltQuoteResponse response = NUT05.quote((PostMeltQuoteRequest)request, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/melt/quote/{method}/{quote_id}"})
    public ResponseEntity<PostMeltQuoteResponse> quoteMelt(@PathVariable(value="method") String method, @PathVariable(value="quote_id") String quoteId) {
        PostMeltQuoteResponse response = NUT05.quotePaymentStatus((String)quoteId, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/melt/{mint_id}/{method}"})
    public ResponseEntity<PostMeltResponse> melt(@RequestBody PostMeltRequest<T> request, @PathVariable(value="method") String method, @PathVariable(value="mint_id") String mintId) throws CashuErrorException {
        PostMeltResponse response = NUT05.melt((UUID)UUID.fromString(mintId), request, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/info"})
    public ResponseEntity<MintInfo> info() {
        MintInfo response = this.nut06.mintInfo();
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/checkstate/{mint_id}"})
    public ResponseEntity<PostCheckStateResponse> checkstate(@RequestBody PostCheckStateRequest request, @PathVariable(value="mint_id") String mintId) throws CashuErrorException {
        PostCheckStateResponse response = NUT07.checkState((UUID)UUID.fromString(mintId), (PostCheckStateRequest)request);
        return ResponseEntity.ok((Object)response);
    }

    @ExceptionHandler(value={CashuErrorException.class})
    public ResponseEntity<ErrorResponse> handleCashuError(CashuErrorException ex) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            ErrorResponse error = (ErrorResponse)mapper.readValue(ex.getMessage(), ErrorResponse.class);
            HttpStatus status = "not found".equalsIgnoreCase(ex.getMessage()) ? HttpStatus.NOT_FOUND : HttpStatus.INTERNAL_SERVER_ERROR;
            return new ResponseEntity((Object)error, (HttpStatusCode)status);
        }
        catch (JsonProcessingException e) {
            ErrorResponse error = new ErrorResponse("internal_error");
            return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

