/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.entity.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.entities.rest.ActiveKeySetResponse;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.KeySetResponse;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.entities.rest.PostRestoreRequest;
import xyz.tcheeric.cashu.entities.rest.PostRestoreResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.cashu.mint.proto.nut.NUT02;
import xyz.tcheeric.cashu.mint.proto.nut.NUT03;
import xyz.tcheeric.cashu.mint.proto.nut.NUT04;
import xyz.tcheeric.cashu.mint.proto.nut.NUT05;
import xyz.tcheeric.cashu.mint.proto.nut.NUT06;
import xyz.tcheeric.cashu.mint.proto.nut.NUT07;
import xyz.tcheeric.cashu.mint.proto.nut.NUT09;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;
import xyz.tcheeric.cashu.mint.proto.util.MintInfo;

@RestController
@RequestMapping(value={"/v1"})
public class CashuController<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CashuController.class);
    private final NUT06 nut06;
    private final MintLoadService mintLoadService;
    private final SignatureVaultService signatureVaultService;

    public CashuController(NUT06 nut06, MintLoadService mintLoadService, SignatureVaultService signatureVaultService) {
        this.nut06 = nut06;
        this.mintLoadService = mintLoadService;
        this.signatureVaultService = signatureVaultService;
    }

    @GetMapping(value={"/keys/{mint_id}/generate"})
    public ResponseEntity<KeySetResponse> generateKeySetIds(@PathVariable(value="mint_id") String mintId) throws CashuErrorException {
        log.debug("Getting keys");
        KeySetResponse response = new KeySetResponse(NUT02.keys((UUID)UUID.fromString(mintId)));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/keys/keyset/{keyset_id}", "/keys/{keyset_id}"})
    public ResponseEntity<KeySetResponse> keyset(@PathVariable(value="keyset_id") String keysetId) throws CashuErrorException {
        log.debug("keys({})", (Object)keysetId);
        KeySet keySet = NUT02.keys((String)keysetId, (MintLoadService)this.mintLoadService);
        KeySetResponse response = new KeySetResponse(List.of(keySet));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/keysets"})
    public ResponseEntity<ActiveKeySetResponse> keysets() throws CashuErrorException {
        List activeKeySets = NUT02.activeKeySets((MintLoadService)this.mintLoadService);
        ActiveKeySetResponse response = new ActiveKeySetResponse(activeKeySets);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/swap/{mint_id}"})
    public ResponseEntity<PostSwapResponse> swap(@PathVariable(value="mint_id") String mintId, @RequestBody PostSwapRequest<T> request) throws CashuErrorException {
        PostSwapResponse response = NUT03.swap((UUID)UUID.fromString(mintId), request, (SignatureVaultService)this.signatureVaultService);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/mint/quote/{method}"})
    public ResponseEntity<PostMintQuoteResponse> quoteMint(@RequestBody PostMintQuoteRequest request, @PathVariable(value="method") String method) {
        PostMintQuoteResponse response = NUT04.quote((int)request.getAmount(), (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/mint/quote/{method}/{quote_id}"})
    public ResponseEntity<PostMintQuoteResponse> quoteMint(@PathVariable(value="method") String method, @PathVariable(value="quote_id") String quoteId) {
        PostMintQuoteResponse response = NUT04.quotePaymentStatus((String)quoteId, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/mint/by-mint/{mintId}/{method}"})
    public ResponseEntity<PostMintResponse> mint(@RequestBody PostMintRequest<T> request, @PathVariable(value="method") String method, @PathVariable(value="mintId") String mintId) throws CashuErrorException {
        PostMintResponse response = NUT04.mint((UUID)UUID.fromString(mintId), request, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()), (SignatureVaultService)this.signatureVaultService);
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/mint/{method}"})
    public ResponseEntity<PostMintResponse> mintByMethod(@RequestBody PostMintRequest<T> request, @PathVariable(value="method") String method) throws CashuErrorException {
        PostMintResponse response;
        if (request.getQuoteId() == null || request.getQuoteId().isBlank()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        List active = this.mintLoadService.load(false);
        if (log.isDebugEnabled()) {
            log.debug("POST /mint/{} quoteId={} activeMints={}", new Object[]{method, request.getQuoteId(), active == null ? 0 : active.size()});
        }
        if (active == null || active.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
        if (active.size() > 1) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        UUID mintId = UUID.fromString(((Mint)active.get(0)).getId());
        PaymentMethod paymentMethod = PaymentMethod.valueOf((String)method.toUpperCase());
        if (log.isDebugEnabled()) {
            log.debug("Delegating mint: mintId={} method={} quoteId={}", new Object[]{mintId, paymentMethod, request.getQuoteId()});
        }
        return (response = NUT04.mint((UUID)mintId, request, (PaymentMethod)paymentMethod, null, (MintLoadService)this.mintLoadService, (MintProtocolService)MintProtocolServiceFactory.getInstance(), (SignatureVaultService)this.signatureVaultService)) == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/melt/quote/{method}"})
    public ResponseEntity<PostMeltQuoteResponse> quoteMelt(@RequestBody PostMeltQuoteRequest request, @PathVariable(value="method") String method) {
        PostMeltQuoteResponse response = NUT05.quote((PostMeltQuoteRequest)request, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/melt/quote/{method}/{quote_id}"})
    public ResponseEntity<PostMeltQuoteResponse> quoteMelt(@PathVariable(value="method") String method, @PathVariable(value="quote_id") String quoteId) {
        PostMeltQuoteResponse response = NUT05.quotePaymentStatus((String)quoteId, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/melt/by-mint/{mint_id}/{method}"})
    public ResponseEntity<PostMeltResponse> melt(@RequestBody PostMeltRequest<T> request, @PathVariable(value="method") String method, @PathVariable(value="mint_id") String mintId) throws CashuErrorException {
        PostMeltResponse response = NUT05.melt((UUID)UUID.fromString(mintId), request, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/melt/{method}"})
    public ResponseEntity<PostMeltResponse> meltByMethod(@RequestBody PostMeltRequest<T> request, @PathVariable(value="method") String method) throws CashuErrorException {
        PaymentMethod paymentMethod;
        if (request.getQuoteId() == null || request.getQuoteId().isBlank()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        List active = this.mintLoadService.load(false);
        if (active == null || active.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
        if (active.size() > 1) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        UUID mintId = UUID.fromString(((Mint)active.get(0)).getId());
        PostMeltResponse response = NUT05.melt((UUID)mintId, request, (PaymentMethod)(paymentMethod = PaymentMethod.valueOf((String)method.toUpperCase())));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/info"})
    public ResponseEntity<ObjectNode> info() {
        MintInfo info = this.nut06.mintInfo();
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = (ObjectNode)mapper.valueToTree((Object)info);
        LinkedHashSet<String> units = new LinkedHashSet<String>();
        LinkedHashSet<String> mintMethods = new LinkedHashSet<String>();
        LinkedHashSet<String> meltMethods = new LinkedHashSet<String>();
        try {
            if (info.getNuts() != null) {
                MintInfo.Nut nut5;
                MintInfo.Nut nut4 = (MintInfo.Nut)info.getNuts().get("4");
                if (nut4 != null && nut4.getMethods() != null) {
                    for (MintInfo.Nut.Method method : nut4.getMethods()) {
                        if (method.getUnit() != null && !method.getUnit().isBlank()) {
                            units.add(method.getUnit());
                        }
                        if (method.getMethod() == null || method.getMethod().isBlank()) continue;
                        mintMethods.add(method.getMethod());
                    }
                }
                if ((nut5 = (MintInfo.Nut)info.getNuts().get("5")) != null && nut5.getMethods() != null) {
                    for (String m : nut5.getMethods()) {
                        if (m.getUnit() != null && !m.getUnit().isBlank()) {
                            units.add(m.getUnit());
                        }
                        if (m.getMethod() == null || m.getMethod().isBlank()) continue;
                        meltMethods.add(m.getMethod());
                    }
                }
            }
        }
        catch (Exception nut4) {
            // empty catch block
        }
        ArrayNode unitsArr = node.putArray("units");
        for (String string : units) {
            unitsArr.add(string);
        }
        ArrayNode mintArr = node.putArray("mint_methods");
        for (String m : mintMethods) {
            mintArr.add(m);
        }
        ArrayNode arrayNode = node.putArray("melt_methods");
        for (String m : meltMethods) {
            arrayNode.add(m);
        }
        return ResponseEntity.ok((Object)node);
    }

    @PostMapping(value={"/checkstate/{mint_id}"})
    public ResponseEntity<PostCheckStateResponse> checkstate(@RequestBody PostCheckStateRequest request, @PathVariable(value="mint_id") String mintId) throws CashuErrorException {
        PostCheckStateResponse response = NUT07.checkState((UUID)UUID.fromString(mintId), (PostCheckStateRequest)request);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/restore"})
    public ResponseEntity<PostRestoreResponse> restore(@RequestBody PostRestoreRequest request) throws CashuErrorException {
        PostRestoreResponse response = NUT09.restore((PostRestoreRequest)request, (SignatureVaultService)this.signatureVaultService);
        return ResponseEntity.ok((Object)response);
    }

    @ExceptionHandler(value={CashuErrorException.class})
    public ResponseEntity<ErrorResponse> handleCashuError(CashuErrorException ex) {
        ErrorResponse error;
        ObjectMapper mapper = new ObjectMapper();
        String rawMessage = ex.getMessage();
        try {
            String s;
            Field detailMessageField = Throwable.class.getDeclaredField("detailMessage");
            detailMessageField.setAccessible(true);
            Object value = detailMessageField.get((Object)ex);
            if (value instanceof String && (s = (String)value) != null) {
                rawMessage = s;
            }
        }
        catch (Exception detailMessageField) {
            // empty catch block
        }
        try {
            error = (ErrorResponse)mapper.readValue(rawMessage, ErrorResponse.class);
        }
        catch (Exception parsePrimary) {
            try {
                error = (ErrorResponse)mapper.readValue(ex.getMessage(), ErrorResponse.class);
            }
            catch (Exception parseFallback) {
                error = new ErrorResponse("internal_error");
            }
        }
        String message = ex.getMessage();
        String normalized = message == null ? "" : message.trim();
        HttpStatus status = normalized.equalsIgnoreCase("not found") || normalized.toLowerCase().contains("not found") ? HttpStatus.NOT_FOUND : HttpStatus.INTERNAL_SERVER_ERROR;
        return new ResponseEntity((Object)error, (HttpStatusCode)status);
    }

    @ExceptionHandler(value={HttpClientErrorException.NotFound.class})
    public ResponseEntity<ErrorResponse> handleGatewayNotFound(HttpClientErrorException.NotFound ex) {
        ErrorResponse error = new ErrorResponse("mint_invoice_not_paid_error");
        return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.PAYMENT_REQUIRED);
    }
}

