/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest;

import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(scanBasePackages={"xyz.tcheeric.cashu"})
public class CashuMintRestApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CashuMintRestApplication.class);

    public static void main(String[] args) {
        SpringApplication.run(CashuMintRestApplication.class, (String[])args);
    }

    @Bean
    ApplicationRunner diagnostics() {
        return args -> {
            try {
                try (InputStream in = CashuMintRestApplication.class.getClassLoader().getResourceAsStream("app.properties");){
                    if (in != null) {
                        Properties p = new Properties();
                        p.load(in);
                        log.info("Diagnostics: classpath app.properties gateway.bolt11={} gateway.bolt11.sat={}", (Object)p.getProperty("gateway.bolt11"), (Object)p.getProperty("gateway.bolt11.sat"));
                    } else {
                        log.warn("Diagnostics: classpath app.properties not found by application classloader");
                    }
                }
                try {
                    Class<?> clazz = Class.forName("xyz.tcheeric.gateway.phoenixd.PhoenixdGateway");
                    Package pkg = clazz.getPackage();
                    log.info("Diagnostics: PhoenixdGateway present. package={} version={}", (Object)(pkg != null ? pkg.getName() : "n/a"), (Object)(pkg != null ? pkg.getImplementationVersion() : "n/a"));
                }
                catch (Throwable t) {
                    log.warn("Diagnostics: PhoenixdGateway class not found on classpath");
                }
            }
            catch (Exception e) {
                log.warn("Diagnostics: failed to collect startup diagnostics", (Throwable)e);
            }
        };
    }
}

