/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.boot;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import xyz.tcheeric.cashu.common.ActiveKeySet;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.mint.proto.nut.NUT02;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;

@Component
@Profile(value={"dev"})
public class DevKeysetHealthIndicator
implements HealthIndicator {
    private final MintLoadService mintLoadService;

    public Health health() {
        try {
            List active = NUT02.activeKeySets((MintLoadService)this.mintLoadService);
            if (active == null || active.isEmpty()) {
                return Health.down().withDetail("reason", (Object)"no_active_keysets").withDetail("hint", (Object)"Generate preload JSON and ensure dev profile is active").build();
            }
            Set units = active.stream().map(ActiveKeySet::getUnit).collect(Collectors.toSet());
            return Health.up().withDetail("activeKeysets", (Object)active.size()).withDetail("units", units).build();
        }
        catch (CashuErrorException e) {
            return Health.down((Throwable)e).withDetail("reason", (Object)"keyset_query_failed").build();
        }
    }

    @Generated
    public DevKeysetHealthIndicator(MintLoadService mintLoadService) {
        this.mintLoadService = mintLoadService;
    }
}

