/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Keys;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.crypto.util.KeySetDerivation;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;

@Service
@Primary
@Profile(value={"dev", "test"})
public class PreloadMintLoadService
implements MintLoadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreloadMintLoadService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Resource preloadJson;

    public PreloadMintLoadService(@Value(value="${mint.preload.json.input:scripts/preload-test-data.json}") Resource preloadJson) {
        this.preloadJson = preloadJson;
    }

    public Mint load(@NonNull UUID mintId, boolean archive) throws CashuErrorException {
        Mint mint;
        block12: {
            if (mintId == null) {
                throw new NullPointerException("mintId is marked non-null but is null");
            }
            InputStream in = this.resolveInput();
            try {
                JsonNode root = MAPPER.readTree(in);
                UUID fileMintId = UUID.fromString(root.path("mintId").asText());
                String unit = root.path("unit").asText();
                String externalKeySetId = root.path("keySetId").asText(null);
                Keys keys = new Keys();
                for (JsonNode k : root.withArray("keys")) {
                    int amount = k.path("amount").asInt();
                    String privateHex = k.path("privateKeyHex").asText();
                    PrivateKey priv = PrivateKey.fromString((String)privateHex);
                    keys.put(BigInteger.valueOf(amount), PrivateKey.derivePublicKey((PrivateKey)priv));
                }
                String keySetId = externalKeySetId != null && !externalKeySetId.isBlank() ? externalKeySetId : KeySetDerivation.getId((Map)keys.values());
                KeySet keySet = KeySet.builder().id(keySetId).unit(unit).keys(keys).build();
                Mint mint2 = new Mint(fileMintId.toString());
                mint2.addKeySet(keySet);
                if (log.isDebugEnabled()) {
                    log.debug("PreloadMintLoadService: loaded mintId={} keySetId={} unit={}", new Object[]{mint2.getId(), keySetId, unit});
                }
                mint = mint2;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CashuErrorException("preload_json_read_error");
                }
                catch (RuntimeException e) {
                    log.warn("Failed to load preload JSON", (Throwable)e);
                    throw new CashuErrorException("preload_json_parse_error");
                }
            }
            in.close();
        }
        return mint;
    }

    public List<Mint> load(boolean archive) throws CashuErrorException {
        ArrayList<Mint> list = new ArrayList<Mint>();
        Mint mint = this.load(UUID.randomUUID(), archive);
        list.add(mint);
        return list;
    }

    private InputStream resolveInput() throws IOException {
        if (this.preloadJson.exists()) {
            return this.preloadJson.getInputStream();
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("scripts/preload-test-data.json");
        if (in != null) {
            return in;
        }
        throw new IOException("Preload JSON not found: " + String.valueOf(this.preloadJson));
    }
}

