/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.config;

import lombok.Generated;
import nostr.base.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import xyz.tcheeric.cashu.mint.rest.config.VoucherProperties;
import xyz.tcheeric.cashu.voucher.app.MerchantVerificationService;
import xyz.tcheeric.cashu.voucher.app.VoucherBackupService;
import xyz.tcheeric.cashu.voucher.app.VoucherIssuanceService;
import xyz.tcheeric.cashu.voucher.app.VoucherService;
import xyz.tcheeric.cashu.voucher.app.ports.VoucherBackupPort;
import xyz.tcheeric.cashu.voucher.app.ports.VoucherLedgerPort;
import xyz.tcheeric.cashu.voucher.nostr.NostrClientAdapter;
import xyz.tcheeric.cashu.voucher.nostr.NostrVoucherBackupRepository;
import xyz.tcheeric.cashu.voucher.nostr.NostrVoucherLedgerRepository;
import xyz.tcheeric.cashu.voucher.nostr.config.NostrRelayConfig;

@Configuration
@EnableConfigurationProperties(value={VoucherProperties.class})
@ConditionalOnProperty(name={"voucher.enabled"}, havingValue="true", matchIfMissing=false)
public class VoucherConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherConfiguration.class);
    private final VoucherProperties voucherProperties;

    @Bean
    public NostrRelayConfig nostrRelayConfig() {
        VoucherProperties.Nostr nostr = this.voucherProperties.getNostr();
        NostrRelayConfig config = NostrRelayConfig.builder().relayUrls(nostr.getRelays()).connectionTimeoutMs(nostr.getConnectionTimeoutMs()).publishTimeoutMs(nostr.getPublishTimeoutMs()).queryTimeoutMs(nostr.getQueryTimeoutMs()).maxRetries(nostr.getMaxRetries()).exponentialBackoff(nostr.isExponentialBackoff()).batchSize(nostr.getBatchSize()).healthCheckEnabled(nostr.isHealthCheckEnabled()).healthCheckIntervalMs(nostr.getHealthCheckIntervalMs()).maxConsecutiveFailures(nostr.getMaxConsecutiveFailures()).autoReconnect(nostr.isAutoReconnect()).requireMinimumRelays(nostr.isRequireMinimumRelays()).minimumRelays(nostr.getMinimumRelays()).build();
        config.validate();
        log.info("Nostr relay config initialized with {} relay(s): {}", (Object)config.getRelayCount(), (Object)config.getRelayUrls());
        return config;
    }

    @Bean
    public NostrClientAdapter nostrClientAdapter(NostrRelayConfig relayConfig) {
        NostrClientAdapter adapter = new NostrClientAdapter(relayConfig.getRelayUrls(), relayConfig.getConnectionTimeoutMs(), relayConfig.getMaxRetries());
        log.info("NostrClientAdapter initialized for voucher operations");
        return adapter;
    }

    @Bean
    public VoucherLedgerPort voucherLedgerPort(NostrClientAdapter nostrClient) {
        PublicKey issuerPublicKey;
        String issuerPublicKeyHex = this.voucherProperties.getMint().getIssuerPublicKey();
        if (issuerPublicKeyHex == null || issuerPublicKeyHex.isBlank()) {
            throw new IllegalStateException("voucher.mint.issuerPublicKey must be configured when voucher.enabled=true");
        }
        try {
            issuerPublicKey = new PublicKey(issuerPublicKeyHex);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid voucher.mint.issuerPublicKey format (must be hex-encoded ED25519 public key): " + issuerPublicKeyHex, e);
        }
        NostrVoucherLedgerRepository repository = new NostrVoucherLedgerRepository(nostrClient, issuerPublicKey);
        log.info("VoucherLedgerPort (Nostr) initialized with issuer public key: {}...", (Object)issuerPublicKeyHex.substring(0, Math.min(8, issuerPublicKeyHex.length())));
        return repository;
    }

    @Bean
    public VoucherBackupPort voucherBackupPort(NostrClientAdapter nostrClient) {
        NostrVoucherBackupRepository repository = new NostrVoucherBackupRepository(nostrClient);
        log.info("VoucherBackupPort (Nostr) initialized for encrypted voucher backups");
        return repository;
    }

    @Bean
    public VoucherService voucherService(VoucherLedgerPort ledgerPort, VoucherBackupPort backupPort) {
        String issuerPrivateKey = this.voucherProperties.getMint().getIssuerPrivateKey();
        String issuerPublicKey = this.voucherProperties.getMint().getIssuerPublicKey();
        if (issuerPrivateKey == null || issuerPrivateKey.isBlank()) {
            throw new IllegalStateException("voucher.mint.issuerPrivateKey must be configured when voucher.enabled=true");
        }
        if (issuerPublicKey == null || issuerPublicKey.isBlank()) {
            throw new IllegalStateException("voucher.mint.issuerPublicKey must be configured when voucher.enabled=true");
        }
        VoucherService service = new VoucherService(ledgerPort, backupPort, issuerPrivateKey, issuerPublicKey);
        log.info("VoucherService initialized successfully");
        return service;
    }

    @Bean
    public VoucherIssuanceService voucherIssuanceService(VoucherService voucherService) {
        VoucherIssuanceService service = new VoucherIssuanceService(voucherService);
        log.info("VoucherIssuanceService initialized");
        return service;
    }

    @Bean
    public VoucherBackupService voucherBackupService(VoucherService voucherService) {
        VoucherBackupService service = new VoucherBackupService(voucherService);
        log.info("VoucherBackupService initialized");
        return service;
    }

    @Bean
    public MerchantVerificationService merchantVerificationService(VoucherLedgerPort ledgerPort) {
        MerchantVerificationService service = new MerchantVerificationService(ledgerPort);
        log.info("MerchantVerificationService initialized");
        return service;
    }

    @Generated
    public VoucherConfiguration(VoucherProperties voucherProperties) {
        this.voucherProperties = voucherProperties;
    }
}

