/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.HashToCurveSecret;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.Secret;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.entities.rest.ActiveKeySetResponse;
import xyz.tcheeric.cashu.entities.rest.ErrorResponse;
import xyz.tcheeric.cashu.entities.rest.KeySetResponse;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.entities.rest.PostRestoreRequest;
import xyz.tcheeric.cashu.entities.rest.PostRestoreResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.cashu.mint.proto.nut.NUT02;
import xyz.tcheeric.cashu.mint.proto.nut.NUT03;
import xyz.tcheeric.cashu.mint.proto.nut.NUT04;
import xyz.tcheeric.cashu.mint.proto.nut.NUT05;
import xyz.tcheeric.cashu.mint.proto.nut.NUT06;
import xyz.tcheeric.cashu.mint.proto.nut.NUT07;
import xyz.tcheeric.cashu.mint.proto.nut.NUT09;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.mint.proto.service.MintProtocolService;
import xyz.tcheeric.cashu.mint.proto.service.MintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.ProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.SignatureVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultMintVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.DefaultProofVaultService;
import xyz.tcheeric.cashu.mint.proto.service.impl.MintProtocolServiceFactory;
import xyz.tcheeric.cashu.mint.proto.util.MintInfo;
import xyz.tcheeric.gateway.common.InvoiceNotPaidException;

@RestController
@RequestMapping(value={"/v1"})
public class CashuController<T extends Secret> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CashuController.class);
    private final NUT06 nut06;
    private final MintLoadService mintLoadService;
    private final SignatureVaultService signatureVaultService;

    public CashuController(NUT06 nut06, MintLoadService mintLoadService, SignatureVaultService signatureVaultService) {
        this.nut06 = nut06;
        this.mintLoadService = mintLoadService;
        this.signatureVaultService = signatureVaultService;
    }

    @GetMapping(value={"/keys/keyset/{keyset_id}", "/keys/{keyset_id}"})
    public ResponseEntity<KeySetResponse> keyset(@PathVariable(value="keyset_id") String keysetId) throws CashuErrorException {
        log.debug("keys({})", (Object)keysetId);
        KeySet keySet = NUT02.keys((String)keysetId, (MintLoadService)this.mintLoadService);
        KeySetResponse response = new KeySetResponse(List.of(keySet));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/keysets"})
    public ResponseEntity<ActiveKeySetResponse> keysets() throws CashuErrorException {
        List activeKeySets = NUT02.activeKeySets((MintLoadService)this.mintLoadService);
        ActiveKeySetResponse response = new ActiveKeySetResponse(activeKeySets);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/swap"})
    public ResponseEntity<PostSwapResponse> swap(@RequestBody PostSwapRequest<T> request) throws CashuErrorException {
        if (request.getInputs() == null || request.getInputs().isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        log.debug("Swapping {} inputs", (Object)request.getInputs().size());
        UUID mintId = this.inferMintIdFromSwapInputs(request);
        if (mintId == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        log.debug("Found mint: {}", (Object)mintId);
        PostSwapResponse response = NUT03.swap((UUID)mintId, request, (MintLoadService)this.mintLoadService, (SignatureVaultService)this.signatureVaultService);
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/mint/quote/{method}"})
    public ResponseEntity<PostMintQuoteResponse> quoteMint(@RequestBody PostMintQuoteRequest request, @PathVariable(value="method") String method) {
        PostMintQuoteResponse response = NUT04.quote((int)request.getAmount(), (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/mint/quote/{method}/{quote_id}"})
    public ResponseEntity<PostMintQuoteResponse> quoteMint(@PathVariable(value="method") String method, @PathVariable(value="quote_id") String quoteId) {
        PostMintQuoteResponse response = NUT04.quotePaymentStatus((String)quoteId, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @Deprecated
    public ResponseEntity<PostMintResponse> mint(PostMintRequest<T> request, String method, String mintId) throws CashuErrorException {
        PostMintResponse response = NUT04.mint((UUID)UUID.fromString(mintId), request, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()), (SignatureVaultService)this.signatureVaultService);
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/mint/{method}"})
    public ResponseEntity<PostMintResponse> mint(@RequestBody PostMintRequest<T> request, @PathVariable(value="method") String method) throws CashuErrorException {
        PostMintResponse response;
        if (request.getQuoteId() == null || request.getQuoteId().isBlank()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        if (request.getBlindedMessages() == null || request.getBlindedMessages().isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        UUID mintId = this.inferMintIdFromMintOutputs(request);
        if (mintId == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        PaymentMethod paymentMethod = PaymentMethod.valueOf((String)method.toUpperCase());
        if (log.isDebugEnabled()) {
            log.debug("Delegating mint: mintId={} method={} quoteId={}", new Object[]{mintId, paymentMethod, request.getQuoteId()});
        }
        return (response = NUT04.mint((UUID)mintId, request, (PaymentMethod)paymentMethod, null, (MintLoadService)this.mintLoadService, (MintProtocolService)MintProtocolServiceFactory.getInstance(), (SignatureVaultService)this.signatureVaultService)) == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/melt/quote/{method}"})
    public ResponseEntity<PostMeltQuoteResponse> quoteMelt(@RequestBody PostMeltQuoteRequest request, @PathVariable(value="method") String method) {
        PostMeltQuoteResponse response = NUT05.quote((PostMeltQuoteRequest)request, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/melt/quote/{method}/{quote_id}"})
    public ResponseEntity<PostMeltQuoteResponse> quoteMelt(@PathVariable(value="method") String method, @PathVariable(value="quote_id") String quoteId) {
        PostMeltQuoteResponse response = NUT05.quotePaymentStatus((String)quoteId, (PaymentMethod)PaymentMethod.valueOf((String)method.toUpperCase()));
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/melt/{method}"})
    public ResponseEntity<PostMeltResponse> melt(@RequestBody PostMeltRequest<T> request, @PathVariable(value="method") String method) throws CashuErrorException {
        if (request.getQuoteId() == null || request.getQuoteId().isBlank()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        if (request.getInputs() == null || request.getInputs().isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        UUID mintId = this.inferMintIdFromProofs(request.getInputs());
        if (mintId == null) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).build();
        }
        PaymentMethod paymentMethod = PaymentMethod.valueOf((String)method.toUpperCase());
        PostMeltResponse response = NUT05.melt((UUID)mintId, request, (PaymentMethod)paymentMethod, null, (MintProtocolService)MintProtocolServiceFactory.getInstance(), (MintLoadService)this.mintLoadService, (MintVaultService)new DefaultMintVaultService(), (ProofVaultService)new DefaultProofVaultService());
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @Deprecated
    public ResponseEntity<PostMeltResponse> melt(PostMeltRequest<T> request, String method, String mintId) throws CashuErrorException {
        PaymentMethod paymentMethod = PaymentMethod.valueOf((String)method.toUpperCase());
        PostMeltResponse response = NUT05.melt((UUID)UUID.fromString(mintId), request, (PaymentMethod)paymentMethod, null, (MintProtocolService)MintProtocolServiceFactory.getInstance(), (MintLoadService)this.mintLoadService, (MintVaultService)new DefaultMintVaultService(), (ProofVaultService)new DefaultProofVaultService());
        return response == null ? ResponseEntity.notFound().build() : ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/info"})
    public ResponseEntity<ObjectNode> info() {
        MintInfo info = this.nut06.mintInfo();
        ObjectNode node = (ObjectNode)new ObjectMapper().valueToTree((Object)info);
        this.addLegacyInfoFields(node, info);
        return ResponseEntity.ok((Object)node);
    }

    @PostMapping(value={"/checkstate"})
    public ResponseEntity<PostCheckStateResponse> checkstate(@RequestBody PostCheckStateRequest request) throws CashuErrorException {
        return ResponseEntity.ok((Object)this.mergeCheckStates(request));
    }

    @PostMapping(value={"/restore"})
    public ResponseEntity<PostRestoreResponse> restore(@RequestBody PostRestoreRequest request) throws CashuErrorException {
        PostRestoreResponse response = NUT09.restore((PostRestoreRequest)request, (SignatureVaultService)this.signatureVaultService);
        return ResponseEntity.ok((Object)response);
    }

    private UUID inferMintIdFromSwapInputs(PostSwapRequest<T> request) throws CashuErrorException {
        if (request.getInputs() == null || request.getInputs().isEmpty()) {
            return null;
        }
        return this.inferMintIdFromProofs(request.getInputs());
    }

    private UUID inferMintIdFromMintOutputs(PostMintRequest<T> request) throws CashuErrorException {
        for (BlindedMessage output : request.getBlindedMessages()) {
            UUID mintId;
            if (output == null || output.getKeySetId() == null || (mintId = this.findMintIdByKeysetId(output.getKeySetId().toString())) == null) continue;
            return mintId;
        }
        return null;
    }

    private UUID inferMintIdFromProofs(List<Proof<T>> proofs) throws CashuErrorException {
        for (Proof<T> proof : proofs) {
            UUID mintId;
            if (proof == null || (mintId = this.findMintIdByKeysetId(proof.getKeySetId())) == null) continue;
            return mintId;
        }
        return null;
    }

    private UUID findMintIdByKeysetId(String keysetId) throws CashuErrorException {
        if (keysetId == null || keysetId.isBlank()) {
            return null;
        }
        for (boolean archive : new boolean[]{false, true}) {
            log.debug("Searching for mint with keyset id {} in archive {}", (Object)keysetId, (Object)archive);
            log.debug("mintLoadService: {}", (Object)this.mintLoadService);
            List mints = this.mintLoadService.load(archive);
            if (mints == null) continue;
            for (Mint mint : mints) {
                log.debug("Mint: {} ", (Object)mint);
                if (mint.getKeySets() == null || !mint.getKeySets().stream().anyMatch(ks -> keysetId.equals(ks.getId()))) continue;
                return UUID.fromString(mint.getId());
            }
        }
        return null;
    }

    private void addLegacyInfoFields(ObjectNode node, MintInfo info) {
        LinkedHashSet<String> units = new LinkedHashSet<String>();
        LinkedHashSet<String> mintMethods = new LinkedHashSet<String>();
        LinkedHashSet<String> meltMethods = new LinkedHashSet<String>();
        try {
            if (info.getNuts() != null) {
                MintInfo.Nut nut5;
                MintInfo.Nut nut4 = (MintInfo.Nut)info.getNuts().get("4");
                if (nut4 != null && nut4.getMethods() != null) {
                    for (MintInfo.Nut.Method method : nut4.getMethods()) {
                        if (method.getUnit() != null && !method.getUnit().isBlank()) {
                            units.add(method.getUnit());
                        }
                        if (method.getMethod() == null || method.getMethod().isBlank()) continue;
                        mintMethods.add(method.getMethod());
                    }
                }
                if ((nut5 = (MintInfo.Nut)info.getNuts().get("5")) != null && nut5.getMethods() != null) {
                    for (String m : nut5.getMethods()) {
                        if (m.getUnit() != null && !m.getUnit().isBlank()) {
                            units.add(m.getUnit());
                        }
                        if (m.getMethod() == null || m.getMethod().isBlank()) continue;
                        meltMethods.add(m.getMethod());
                    }
                }
            }
        }
        catch (Exception nut4) {
            // empty catch block
        }
        ArrayNode unitsArr = node.putArray("units");
        for (String string : units) {
            unitsArr.add(string);
        }
        ArrayNode mintArr = node.putArray("mint_methods");
        for (String m : mintMethods) {
            mintArr.add(m);
        }
        ArrayNode arrayNode = node.putArray("melt_methods");
        for (String m : meltMethods) {
            arrayNode.add(m);
        }
    }

    private PostCheckStateResponse mergeCheckStates(PostCheckStateRequest request) throws CashuErrorException {
        List archived;
        LinkedHashMap stateByKey = new LinkedHashMap();
        BiConsumer<String, String> merge = (k, s) -> {
            String prev = (String)stateByKey.get(k);
            if (prev == null) {
                stateByKey.put(k, s);
            } else if ("SPENT".equals(s) || "PENDING".equals(s) && "UNSPENT".equals(prev)) {
                stateByKey.put(k, s);
            }
        };
        List active = this.mintLoadService.load(false);
        if (active != null) {
            for (Object m : active) {
                this.mergeFromMintStates(merge, (Mint)m, request);
            }
        }
        if (stateByKey.isEmpty() && (archived = this.mintLoadService.load(true)) != null) {
            for (Mint m : archived) {
                this.mergeFromMintStates(merge, m, request);
            }
        }
        PostCheckStateResponse out = new PostCheckStateResponse();
        ArrayList<PostCheckStateResponse.ResponseState> list = new ArrayList<PostCheckStateResponse.ResponseState>();
        for (Map.Entry e : stateByKey.entrySet()) {
            PostCheckStateResponse.ResponseState rs = new PostCheckStateResponse.ResponseState();
            rs.setHashToCurveSecret(HashToCurveSecret.fromString((String)((String)e.getKey())));
            rs.setState((String)e.getValue());
            list.add(rs);
        }
        out.setStates(list);
        return out;
    }

    private void mergeFromMintStates(BiConsumer<String, String> merge, Mint mint, PostCheckStateRequest request) throws CashuErrorException {
        PostCheckStateResponse resp = NUT07.checkState((UUID)UUID.fromString(mint.getId()), (PostCheckStateRequest)request);
        if (resp == null || resp.getStates() == null) {
            return;
        }
        for (PostCheckStateResponse.ResponseState st : resp.getStates()) {
            if (st.getHashToCurveSecret() == null || st.getState() == null) continue;
            merge.accept(st.getHashToCurveSecret().toString(), st.getState());
        }
    }

    @ExceptionHandler(value={CashuErrorException.class})
    public ResponseEntity<ErrorResponse> handleCashuError(CashuErrorException ex) {
        ErrorResponse error;
        ObjectMapper mapper = new ObjectMapper();
        String rawMessage = ex.getMessage();
        try {
            String s;
            Field detailMessageField = Throwable.class.getDeclaredField("detailMessage");
            detailMessageField.setAccessible(true);
            Object value = detailMessageField.get(ex);
            if (value instanceof String && (s = (String)value) != null) {
                rawMessage = s;
            }
        }
        catch (Exception detailMessageField) {
            // empty catch block
        }
        try {
            error = (ErrorResponse)mapper.readValue(rawMessage, ErrorResponse.class);
        }
        catch (Exception parsePrimary) {
            try {
                error = (ErrorResponse)mapper.readValue(ex.getMessage(), ErrorResponse.class);
            }
            catch (Exception parseFallback) {
                error = new ErrorResponse("internal_error");
            }
        }
        String message = ex.getMessage();
        String normalized = message == null ? "" : message.trim();
        HttpStatus status = normalized.equalsIgnoreCase("not found") || normalized.toLowerCase().contains("not found") ? HttpStatus.NOT_FOUND : HttpStatus.INTERNAL_SERVER_ERROR;
        return new ResponseEntity((Object)error, (HttpStatusCode)status);
    }

    @ExceptionHandler(value={HttpClientErrorException.NotFound.class})
    public ResponseEntity<ErrorResponse> handleGatewayNotFound(HttpClientErrorException.NotFound ex) {
        ErrorResponse error = new ErrorResponse("mint_invoice_not_paid_error");
        return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.PAYMENT_REQUIRED);
    }

    @ExceptionHandler(value={InvoiceNotPaidException.class})
    public ResponseEntity<ErrorResponse> handleInvoiceNotPaid(InvoiceNotPaidException ex) {
        ErrorResponse error = new ErrorResponse("mint_invoice_not_paid_error");
        return new ResponseEntity((Object)error, (HttpStatusCode)HttpStatus.PAYMENT_REQUIRED);
    }
}

