/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.controller;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import xyz.tcheeric.cashu.mint.rest.controller.VoucherController;
import xyz.tcheeric.cashu.voucher.app.VoucherService;
import xyz.tcheeric.cashu.voucher.app.dto.IssueVoucherRequest;
import xyz.tcheeric.cashu.voucher.app.dto.IssueVoucherResponse;
import xyz.tcheeric.cashu.voucher.domain.VoucherStatus;

@RestController
@RequestMapping(value={"/v1/vouchers"})
@ConditionalOnBean(value={VoucherService.class})
public class VoucherController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherController.class);
    private final VoucherService voucherService;

    @PostMapping
    public ResponseEntity<IssueVoucherResponse> issueVoucher(@RequestBody IssueVoucherRequest request) {
        log.info("POST /v1/vouchers - Issuing voucher for issuer={}, unit={}, amount={}", new Object[]{request.getIssuerId(), request.getUnit(), request.getAmount()});
        if (request.getIssuerId() == null || request.getIssuerId().isBlank()) {
            log.warn("Voucher issuance rejected: missing issuerId");
            return ResponseEntity.badRequest().build();
        }
        if (request.getUnit() == null || request.getUnit().isBlank()) {
            log.warn("Voucher issuance rejected: missing unit");
            return ResponseEntity.badRequest().build();
        }
        if (request.getAmount() == null || request.getAmount() <= 0L) {
            log.warn("Voucher issuance rejected: invalid amount={}", (Object)request.getAmount());
            return ResponseEntity.badRequest().build();
        }
        if (request.getExpiresInDays() != null && request.getExpiresInDays() <= 0) {
            log.warn("Voucher issuance rejected: invalid expiresInDays={}", (Object)request.getExpiresInDays());
            return ResponseEntity.badRequest().build();
        }
        try {
            IssueVoucherResponse response = this.voucherService.issue(request);
            log.info("Voucher issued successfully: voucherId={}, amount={} {}", new Object[]{response.getVoucherId(), response.getAmount(), response.getUnit()});
            return ResponseEntity.ok((Object)response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Voucher issuance rejected: {}", (Object)e.getMessage());
            return ResponseEntity.badRequest().build();
        }
        catch (Exception e) {
            log.error("Failed to issue voucher: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/{voucherId}/status"})
    public ResponseEntity<VoucherStatusResponse> getVoucherStatus(@PathVariable(value="voucherId") String voucherId) {
        log.debug("GET /v1/vouchers/{}/status", (Object)voucherId);
        if (voucherId == null || voucherId.isBlank()) {
            log.warn("Voucher status query rejected: missing voucherId");
            return ResponseEntity.badRequest().build();
        }
        try {
            Optional status = this.voucherService.queryStatus(voucherId);
            if (status.isEmpty()) {
                log.debug("Voucher not found: voucherId={}", (Object)voucherId);
                return ResponseEntity.notFound().build();
            }
            VoucherStatusResponse response = new VoucherStatusResponse(voucherId, (VoucherStatus)status.get());
            log.debug("Voucher status retrieved: voucherId={}, status={}", (Object)voucherId, status.get());
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            log.error("Failed to query voucher status for voucherId={}: {}", new Object[]{voucherId, e.getMessage(), e});
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Map<String, String>> handleException(Exception e) {
        log.error("Unhandled voucher controller exception: {}", (Object)e.getMessage(), (Object)e);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Internal server error", "message", e.getMessage() != null ? e.getMessage() : "Unknown error"));
    }

    @Generated
    public VoucherController(VoucherService voucherService) {
        this.voucherService = voucherService;
    }
}

