/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.boot;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import xyz.tcheeric.cashu.common.ActiveKeySet;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.mint.proto.nut.NUT02;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;

@Component
@Profile(value={"dev"})
public class DevKeysetStartupCheck
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DevKeysetStartupCheck.class);
    private final MintLoadService mintLoadService;

    public void run(ApplicationArguments args) {
        try {
            List active = NUT02.activeKeySets((MintLoadService)this.mintLoadService);
            if (active == null || active.isEmpty()) {
                log.warn("No active keysets detected in dev profile. Ensure preload JSON exists at scripts/preload-test-data.json or set MINT_PRELOAD_JSON_INPUT, then restart.");
            } else {
                Set units = active.stream().map(ActiveKeySet::getUnit).collect(Collectors.toSet());
                log.info("Active keysets available (count={} units={})", (Object)active.size(), units);
            }
        }
        catch (CashuErrorException e) {
            log.warn("Dev keyset startup check failed to query active keysets", (Throwable)e);
        }
    }

    @Generated
    public DevKeysetStartupCheck(MintLoadService mintLoadService) {
        this.mintLoadService = mintLoadService;
    }
}

