/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.Keys;
import xyz.tcheeric.cashu.common.Mint;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.common.util.CashuErrorException;
import xyz.tcheeric.cashu.crypto.util.KeySetDerivation;
import xyz.tcheeric.cashu.mint.proto.service.MintLoadService;
import xyz.tcheeric.cashu.vault.api.VaultClientFactory;
import xyz.tcheeric.cashu.vault.db.client.KeySetVaultClient;
import xyz.tcheeric.cashu.vault.db.client.KeyVaultClient;
import xyz.tcheeric.cashu.vault.db.client.VaultClient;
import xyz.tcheeric.cashu.vault.db.model.BaseEntity;
import xyz.tcheeric.cashu.vault.db.model.KeyEntity;
import xyz.tcheeric.cashu.vault.db.model.KeySetEntity;
import xyz.tcheeric.cashu.vault.db.model.MintEntity;

@Service
@Primary
@ConditionalOnProperty(name={"mint.preload.enabled"}, havingValue="true", matchIfMissing=true)
public class PreloadMintLoadService
implements MintLoadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreloadMintLoadService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Resource preloadJson;
    private final Object vaultSeedLock = new Object();
    private final AtomicBoolean vaultSeeded = new AtomicBoolean(false);

    public PreloadMintLoadService(@Value(value="${mint.preload.json.input:scripts/preload-test-data.json}") Resource preloadJson) {
        this.preloadJson = preloadJson;
    }

    public Mint load(@NonNull UUID mintId, boolean archive) throws CashuErrorException {
        Mint mint;
        block12: {
            if (mintId == null) {
                throw new NullPointerException("mintId is marked non-null but is null");
            }
            InputStream in = this.resolveInput();
            try {
                JsonNode root = MAPPER.readTree(in);
                UUID fileMintId = UUID.fromString(root.path("mintId").asText());
                String unit = root.path("unit").asText();
                String externalKeySetId = root.path("keySetId").asText(null);
                this.seedVaultIfNeeded(root);
                Keys keys = new Keys();
                for (JsonNode k : root.withArray("keys")) {
                    int amount = k.path("amount").asInt();
                    String privateHex = k.path("privateKeyHex").asText();
                    PrivateKey priv = PrivateKey.fromString((String)privateHex);
                    keys.put(BigInteger.valueOf(amount), PrivateKey.derivePublicKey((PrivateKey)priv));
                }
                String keySetId = externalKeySetId != null && !externalKeySetId.isBlank() ? externalKeySetId : KeySetDerivation.getId((Map)keys.values());
                KeySet keySet = KeySet.builder().id(keySetId).unit(unit).keys(keys).build();
                Mint mint2 = new Mint(fileMintId.toString());
                mint2.addKeySet(keySet);
                if (log.isDebugEnabled()) {
                    log.debug("PreloadMintLoadService: loaded mintId={} keySetId={} unit={}", new Object[]{mint2.getId(), keySetId, unit});
                }
                mint = mint2;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CashuErrorException("preload_json_read_error");
                }
                catch (RuntimeException e) {
                    log.warn("Failed to load preload JSON", (Throwable)e);
                    throw new CashuErrorException("preload_json_parse_error");
                }
            }
            in.close();
        }
        return mint;
    }

    public List<Mint> load(boolean archive) throws CashuErrorException {
        ArrayList<Mint> list = new ArrayList<Mint>();
        Mint mint = this.load(UUID.randomUUID(), archive);
        list.add(mint);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seedVaultIfNeeded(JsonNode root) {
        if (this.vaultSeeded.get()) {
            return;
        }
        Object object = this.vaultSeedLock;
        synchronized (object) {
            if (this.vaultSeeded.get()) {
                return;
            }
            try {
                KeySetEntity storedKeySet;
                MintEntity storedMint;
                KeySetVaultClient keySetClient;
                VaultClient mintClient;
                String keySetRowId;
                String keySetId;
                String unit;
                UUID mintUuid;
                block29: {
                    mintUuid = UUID.fromString(root.path("mintId").asText());
                    unit = root.path("unit").asText();
                    keySetId = root.path("keySetId").asText();
                    keySetRowId = root.path("keySetRowId").asText(null);
                    mintClient = VaultClientFactory.getClient(MintEntity.class);
                    keySetClient = VaultClientFactory.keySetClient();
                    storedMint = null;
                    try {
                        MintEntity existingMint = (MintEntity)mintClient.retrieve(mintUuid.toString());
                        if (existingMint == null) break block29;
                        storedMint = existingMint;
                        log.debug("PreloadMintLoadService: mint {} already present, verifying keys", (Object)mintUuid);
                        try {
                            KeySetEntity existingKeySet = keySetClient.getByKeySetId(keySetId);
                            if (existingKeySet != null) {
                                this.ensureVaultKeys(existingKeySet, root);
                                this.vaultSeeded.set(true);
                                return;
                            }
                        }
                        catch (Exception existingKeySet) {}
                    }
                    catch (HttpClientErrorException.NotFound existingMint) {
                    }
                    catch (HttpClientErrorException e) {
                        if (e.getStatusCode() == HttpStatus.CONFLICT) {
                            log.debug("PreloadMintLoadService: mint {} already present (conflict), skipping seed", (Object)mintUuid);
                            this.vaultSeeded.set(true);
                            return;
                        }
                        throw e;
                    }
                }
                KeySetEntity existing = null;
                try {
                    existing = keySetClient.getByKeySetId(keySetId);
                    if (existing != null) {
                        log.debug("PreloadMintLoadService: keyset {} already present, verifying keys", (Object)keySetId);
                        this.ensureVaultKeys(existing, root);
                        this.vaultSeeded.set(true);
                        return;
                    }
                }
                catch (Exception existingKeySet) {
                    // empty catch block
                }
                MintEntity mintEntity = storedMint;
                if (mintEntity == null) {
                    mintEntity = new MintEntity();
                    mintEntity.setId(mintUuid);
                    try {
                        mintEntity = (MintEntity)mintClient.store((BaseEntity)mintEntity);
                    }
                    catch (HttpClientErrorException.Conflict conflict) {
                        mintEntity = (MintEntity)mintClient.retrieve(mintUuid.toString());
                    }
                }
                KeySetEntity keySetEntity = new KeySetEntity();
                if (keySetRowId != null && !keySetRowId.isBlank()) {
                    keySetEntity.setId(UUID.fromString(keySetRowId));
                }
                keySetEntity.setKeySetId(keySetId);
                keySetEntity.setUnit(unit);
                keySetEntity.setMint(mintEntity);
                LinkedHashSet<KeyEntity> keysToSeed = new LinkedHashSet<KeyEntity>();
                for (JsonNode k : root.withArray("keys")) {
                    KeyEntity keyEntity = new KeyEntity();
                    String keyId = k.path("id").asText(null);
                    if (keyId != null && !keyId.isBlank()) {
                        keyEntity.setId(UUID.fromString(keyId));
                    }
                    keyEntity.setAmount(new BigInteger(k.path("amount").asText()));
                    keyEntity.setPrivateKey(k.path("privateKeyHex").asText());
                    keysToSeed.add(keyEntity);
                }
                try {
                    storedKeySet = (KeySetEntity)keySetClient.store((BaseEntity)keySetEntity);
                }
                catch (HttpClientErrorException.Conflict conflict) {
                    storedKeySet = keySetClient.getByKeySetId(keySetId);
                }
                for (KeyEntity keyEntity : keysToSeed) {
                    keyEntity.setKeySet(storedKeySet);
                    try {
                        VaultClientFactory.keyClient().store((BaseEntity)keyEntity);
                    }
                    catch (HttpClientErrorException.Conflict conflict) {}
                }
                log.info("PreloadMintLoadService: seeded vault with mint {} keyset {} ({} keys)", new Object[]{mintUuid, keySetId, keysToSeed.size()});
                this.vaultSeeded.set(true);
            }
            catch (Exception e) {
                if (e instanceof HttpClientErrorException.Conflict) {
                    HttpClientErrorException.Conflict conflict = (HttpClientErrorException.Conflict)((Object)e);
                    log.debug("PreloadMintLoadService: mint {} already present, skipping seed", (Object)root.path("mintId").asText());
                    this.vaultSeeded.set(true);
                    return;
                }
                log.warn("PreloadMintLoadService: failed to seed vault from preload JSON", (Throwable)e);
                this.vaultSeeded.set(false);
            }
        }
    }

    private void ensureVaultKeys(KeySetEntity keySetEntity, JsonNode root) {
        if (keySetEntity == null) {
            return;
        }
        try {
            KeyVaultClient keyClient = VaultClientFactory.keyClient();
            Set existingKeys = keyClient.getKeysByKeySetId(keySetEntity.getId().toString());
            HashMap<BigInteger, KeyEntity> byAmount = new HashMap<BigInteger, KeyEntity>();
            if (existingKeys != null) {
                for (KeyEntity key : existingKeys) {
                    byAmount.put(key.getAmount(), key);
                }
            }
            for (JsonNode node : root.withArray("keys")) {
                BigInteger amount = new BigInteger(node.path("amount").asText());
                if (byAmount.containsKey(amount)) continue;
                KeyEntity newKey = new KeyEntity();
                String keyId = node.path("id").asText(null);
                if (keyId != null && !keyId.isBlank()) {
                    newKey.setId(UUID.fromString(keyId));
                }
                newKey.setAmount(amount);
                newKey.setPrivateKey(node.path("privateKeyHex").asText());
                newKey.setKeySet(keySetEntity);
                VaultClientFactory.keyClient().store((BaseEntity)newKey);
                log.info("PreloadMintLoadService: added missing key amount={} for keyset {}", (Object)amount, (Object)keySetEntity.getKeySetId());
            }
        }
        catch (Exception e) {
            log.warn("PreloadMintLoadService: failed to ensure vault keys for keyset {}", (Object)keySetEntity.getKeySetId(), (Object)e);
        }
    }

    private InputStream resolveInput() throws IOException {
        if (this.preloadJson.exists()) {
            return this.preloadJson.getInputStream();
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("scripts/preload-test-data.json");
        if (in != null) {
            return in;
        }
        throw new IOException("Preload JSON not found: " + String.valueOf(this.preloadJson));
    }
}

