/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.rest.client;

import java.util.List;
import java.util.Objects;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.entities.rest.ActiveKeySetResponse;
import xyz.tcheeric.cashu.entities.rest.KeySetResponse;
import xyz.tcheeric.cashu.mint.proto.util.MintInfo;
import xyz.tcheeric.cashu.mint.rest.client.BaseClient;

public class CashuClient
extends BaseClient {
    private static final String API_VERSION_PREFIX = "/v1";

    public List<KeySet> keys() {
        String url = this.getBaseUrl() + "/keys";
        KeySetResponse response = (KeySetResponse)this.restTemplate.getForObject(url, KeySetResponse.class, new Object[0]);
        return Objects.requireNonNull(response).getKeysets();
    }

    public List<KeySet> keys(String keysetId) {
        String url = this.getBaseUrl() + "/keys/" + keysetId;
        KeySetResponse response = (KeySetResponse)this.restTemplate.getForObject(url, KeySetResponse.class, new Object[0]);
        return Objects.requireNonNull(response).getKeysets();
    }

    public ActiveKeySetResponse keysets() {
        String url = this.getBaseUrl() + "/keysets";
        return (ActiveKeySetResponse)this.restTemplate.getForObject(url, ActiveKeySetResponse.class, new Object[0]);
    }

    public MintInfo info() {
        String url = this.getBaseUrl() + "/info";
        return (MintInfo)this.restTemplate.getForObject(url, MintInfo.class, new Object[0]);
    }

    @Override
    protected String getBaseUrl() {
        String address;
        String string = address = System.getProperty("server.address") != null ? System.getProperty("server.address") : this.serverAddress;
        String port = System.getProperty("cashu_mint_port") != null ? System.getProperty("cashu_mint_port") : (this.serverPort != null ? this.serverPort : "7777");
        return "http://" + address + ":" + port + API_VERSION_PREFIX;
    }
}

