/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.cashu.mint.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import xyz.tcheeric.cashu.common.Keys;
import xyz.tcheeric.cashu.common.PrivateKey;
import xyz.tcheeric.cashu.crypto.util.KeySetDerivation;
import xyz.tcheeric.cashu.mint.tools.MintPreloadData;

public final class MintPreloadDataGenerator {
    public static final List<Integer> DEFAULT_DENOMINATIONS = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(16), Integer.valueOf(32), Integer.valueOf(64), Integer.valueOf(128));
    public static final String DEFAULT_UNIT = "sat";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final UUID mintId;
    private final String unit;
    private final List<Integer> denominations;
    private final Function<Integer, String> privateKeyHexGenerator;
    private MintPreloadData cachedData;

    public MintPreloadDataGenerator(@NonNull UUID mintId, @NonNull String unit, @NonNull List<Integer> denominations) {
        this(mintId, unit, denominations, amount -> null);
        if (mintId == null) {
            throw new NullPointerException("mintId is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (denominations == null) {
            throw new NullPointerException("denominations is marked non-null but is null");
        }
    }

    MintPreloadDataGenerator(@NonNull UUID mintId, @NonNull String unit, @NonNull List<Integer> denominations, @NonNull Function<Integer, String> privateKeyHexGenerator) {
        if (denominations == null) {
            throw new NullPointerException("denominations is marked non-null but is null");
        }
        this.mintId = Objects.requireNonNull(mintId, "mintId");
        this.unit = Objects.requireNonNull(unit, "unit");
        this.privateKeyHexGenerator = Objects.requireNonNull(privateKeyHexGenerator, "privateKeyHexGenerator");
        ArrayList copy = new ArrayList((Collection)Objects.requireNonNull(denominations, "denominations"));
        copy.sort(Comparator.naturalOrder());
        this.denominations = List.copyOf(copy);
    }

    public MintPreloadData data() {
        if (this.cachedData == null) {
            this.cachedData = this.createData();
        }
        return this.cachedData;
    }

    public String buildJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this.data());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to serialise mint preload data", e);
        }
    }

    public void writeJson(@NonNull Path output) throws IOException {
        Objects.requireNonNull(output, "output");
        Path parent = output.toAbsolutePath().getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.writeString(output, (CharSequence)this.buildJson(), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void main(String[] args) throws IOException {
        String outputArg = args.length > 0 ? args[0] : null;
        Path output = outputArg == null || outputArg.isBlank() ? Path.of("scripts/preload-test-data.json", new String[0]) : Path.of(outputArg, new String[0]);
        String mintIdArg = args.length > 1 ? args[1] : null;
        UUID mintId = mintIdArg == null || mintIdArg.isBlank() ? UUID.randomUUID() : UUID.fromString(mintIdArg);
        MintPreloadDataGenerator generator = new MintPreloadDataGenerator(mintId, DEFAULT_UNIT, DEFAULT_DENOMINATIONS);
        generator.writeJson(output);
        MintPreloadData data = generator.data();
        System.out.printf("Generated preload JSON for mint %s and keyset %s at %s%n", data.mintId(), data.keySetId(), output.toAbsolutePath());
    }

    private MintPreloadData createData() {
        Keys keys = new Keys();
        ArrayList<MintPreloadData.DenominationKey> keyMaterials = new ArrayList<MintPreloadData.DenominationKey>();
        for (Integer amount : this.denominations) {
            String privateKeyHex = this.derivePrivateKeyHex(amount);
            PrivateKey privateKey = MintPreloadDataGenerator.toPrivateKey(privateKeyHex);
            keys.put(BigInteger.valueOf(amount.longValue()), PrivateKey.derivePublicKey((PrivateKey)privateKey));
            UUID keyId = MintPreloadDataGenerator.deterministicId(this.mintId, this.unit, amount.toString());
            keyMaterials.add(new MintPreloadData.DenominationKey(keyId, amount, privateKeyHex));
        }
        String keySetId = KeySetDerivation.getId((Map)keys.values());
        UUID keySetRowId = MintPreloadDataGenerator.deterministicId(this.mintId, this.unit, keySetId);
        return new MintPreloadData(this.mintId, keySetId, keySetRowId, this.unit, List.copyOf(keyMaterials));
    }

    private String derivePrivateKeyHex(Integer amount) {
        String provided = this.privateKeyHexGenerator.apply(amount);
        if (provided != null && !provided.isBlank()) {
            return provided;
        }
        return this.deriveDeterministicPrivateKey(amount);
    }

    private String deriveDeterministicPrivateKey(Integer amount) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String material = String.valueOf(this.mintId) + "|" + this.unit + "|" + amount;
            byte[] hash = digest.digest(material.getBytes(StandardCharsets.UTF_8));
            return MintPreloadDataGenerator.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 algorithm not available", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static UUID deterministicId(UUID mintId, String unit, String value) {
        String source = String.valueOf(mintId) + "|" + unit + "|" + value;
        return UUID.nameUUIDFromBytes(source.getBytes(StandardCharsets.UTF_8));
    }

    private static PrivateKey toPrivateKey(String privateKeyHex) {
        try {
            return PrivateKey.fromString((String)privateKeyHex);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid private key hex", e);
        }
    }
}

